/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.bottomappbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Dimension;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.design.R;
import android.support.design.animation.AnimationUtils;
import android.support.design.behavior.HideBottomViewOnScrollBehavior;
import android.support.design.bottomappbar.BottomAppBarTopEdgeTreatment;
import android.support.design.internal.ThemeEnforcement;
import android.support.design.resources.MaterialResources;
import android.support.design.shape.MaterialShapeDrawable;
import android.support.design.shape.ShapePathModel;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.AbsSavedState;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.ActionMenuView;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class BottomAppBar
extends Toolbar
implements CoordinatorLayout.AttachedBehavior {
    private static final long ANIMATION_DURATION = 300L;
    public static final int FAB_ALIGNMENT_MODE_CENTER = 0;
    public static final int FAB_ALIGNMENT_MODE_END = 1;
    private final int fabOffsetEndMode;
    private final MaterialShapeDrawable materialShapeDrawable;
    private final BottomAppBarTopEdgeTreatment topEdgeTreatment;
    @Nullable
    private Animator attachAnimator;
    @Nullable
    private Animator modeAnimator;
    @Nullable
    private Animator menuAnimator;
    private int fabAlignmentMode;
    private boolean hideOnScroll;
    private boolean fabAttached = true;
    AnimatorListenerAdapter fabAnimationListener = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            BottomAppBar.this.maybeAnimateAttachChange(BottomAppBar.this.fabAttached);
            BottomAppBar.this.maybeAnimateMenuView(BottomAppBar.this.fabAlignmentMode, BottomAppBar.this.fabAttached);
        }
    };

    public BottomAppBar(Context context) {
        this(context, null, 0);
    }

    public BottomAppBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.bottomAppBarStyle);
    }

    public BottomAppBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.BottomAppBar, defStyleAttr, R.style.Widget_MaterialComponents_BottomAppBar, new int[0]);
        ColorStateList backgroundTint = MaterialResources.getColorStateList(context, a, R.styleable.BottomAppBar_backgroundTint);
        float fabCradleMargin = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleMargin, 0);
        float fabCornerRadius = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleRoundedCornerRadius, 0);
        float fabVerticalOffset = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleVerticalOffset, 0);
        this.fabAlignmentMode = a.getInt(R.styleable.BottomAppBar_fabAlignmentMode, 0);
        this.hideOnScroll = a.getBoolean(R.styleable.BottomAppBar_hideOnScroll, false);
        a.recycle();
        this.fabOffsetEndMode = this.getResources().getDimensionPixelOffset(R.dimen.mtrl_bottomappbar_fabOffsetEndMode);
        this.topEdgeTreatment = new BottomAppBarTopEdgeTreatment(fabCradleMargin, fabCornerRadius, fabVerticalOffset);
        ShapePathModel appBarModel = new ShapePathModel();
        appBarModel.setTopEdge(this.topEdgeTreatment);
        this.materialShapeDrawable = new MaterialShapeDrawable(appBarModel);
        this.materialShapeDrawable.setShadowEnabled(true);
        this.materialShapeDrawable.setPaintStyle(Paint.Style.FILL);
        DrawableCompat.setTintList((Drawable)this.materialShapeDrawable, (ColorStateList)backgroundTint);
        ViewCompat.setBackground((View)this, (Drawable)this.materialShapeDrawable);
    }

    public int getFabAlignmentMode() {
        return this.fabAlignmentMode;
    }

    public void setFabAlignmentMode(int fabAlignmentMode) {
        this.maybeAnimateModeChange(fabAlignmentMode);
        this.maybeAnimateMenuView(fabAlignmentMode, this.fabAttached);
        this.fabAlignmentMode = fabAlignmentMode;
    }

    public void setBackgroundTint(@Nullable ColorStateList backgroundTint) {
        DrawableCompat.setTintList((Drawable)this.materialShapeDrawable, (ColorStateList)backgroundTint);
    }

    @Nullable
    public ColorStateList getBackgroundTint() {
        return this.materialShapeDrawable.getTintList();
    }

    public float getFabCradleMargin() {
        return this.topEdgeTreatment.getFabCradleMargin();
    }

    public void setFabCradleMargin(@Dimension float cradleMargin) {
        if (cradleMargin != this.getFabCradleMargin()) {
            this.topEdgeTreatment.setFabCradleMargin(cradleMargin);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    @Dimension
    public float getFabCradleRoundedCornerRadius() {
        return this.topEdgeTreatment.getFabCradleRoundedCornerRadius();
    }

    public void setFabCradleRoundedCornerRadius(@Dimension float roundedCornerRadius) {
        if (roundedCornerRadius != this.getFabCradleRoundedCornerRadius()) {
            this.topEdgeTreatment.setFabCradleRoundedCornerRadius(roundedCornerRadius);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    @Dimension
    public float getCradleVerticalOffset() {
        return this.topEdgeTreatment.getCradleVerticalOffset();
    }

    public void setCradleVerticalOffset(@Dimension float verticalOffset) {
        if (verticalOffset != this.getCradleVerticalOffset()) {
            this.topEdgeTreatment.setCradleVerticalOffset(verticalOffset);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    public boolean getHideOnScroll() {
        return this.hideOnScroll;
    }

    public void setHideOnScroll(boolean hide) {
        this.hideOnScroll = hide;
    }

    public void replaceMenu(@MenuRes int newMenu) {
        this.getMenu().clear();
        this.inflateMenu(newMenu);
    }

    void setFabDiameter(@Px int diameter) {
        if ((float)diameter != this.topEdgeTreatment.getFabDiameter()) {
            this.topEdgeTreatment.setFabDiameter(diameter);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    private void maybeAnimateModeChange(int targetMode) {
        if (this.fabAlignmentMode == targetMode || !ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (this.modeAnimator != null) {
            this.modeAnimator.cancel();
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        this.createCradleTranslationAnimation(targetMode, animators);
        this.createFabTranslationXAnimation(targetMode, animators);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        this.modeAnimator = set;
        this.modeAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BottomAppBar.this.modeAnimator = null;
            }
        });
        this.modeAnimator.start();
    }

    private void createCradleTranslationAnimation(int targetMode, List<Animator> animators) {
        if (!this.fabAttached) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.topEdgeTreatment.getHorizontalOffset(), this.getFabTranslationX(targetMode)});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BottomAppBar.this.topEdgeTreatment.setHorizontalOffset(((Float)animation.getAnimatedValue()).floatValue());
                BottomAppBar.this.materialShapeDrawable.invalidateSelf();
            }
        });
        animator.setDuration(300L);
        animators.add((Animator)animator);
    }

    @Nullable
    private FloatingActionButton findDependentFab() {
        if (!(this.getParent() instanceof CoordinatorLayout)) {
            return null;
        }
        List dependents = ((CoordinatorLayout)this.getParent()).getDependents((View)this);
        for (View v : dependents) {
            if (!(v instanceof FloatingActionButton)) continue;
            return (FloatingActionButton)v;
        }
        return null;
    }

    private boolean isVisibleFab() {
        FloatingActionButton fab = this.findDependentFab();
        return fab != null && fab.isOrWillBeShown();
    }

    private void createFabTranslationXAnimation(int targetMode, List<Animator> animators) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.findDependentFab(), (String)"translationX", (float[])new float[]{this.getFabTranslationX(targetMode)});
        animator.setDuration(300L);
        animators.add((Animator)animator);
    }

    private void maybeAnimateMenuView(int targetMode, boolean newFabAttached) {
        if (!ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (this.menuAnimator != null) {
            this.menuAnimator.cancel();
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        if (!this.isVisibleFab()) {
            targetMode = 0;
            newFabAttached = false;
        }
        this.createMenuViewTranslationAnimation(targetMode, newFabAttached, animators);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        this.menuAnimator = set;
        this.menuAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BottomAppBar.this.menuAnimator = null;
            }
        });
        this.menuAnimator.start();
    }

    private void createMenuViewTranslationAnimation(final int targetMode, final boolean targetAttached, List<Animator> animators) {
        final ActionMenuView actionMenuView = this.getActionMenuView();
        if (actionMenuView == null) {
            return;
        }
        ObjectAnimator fadeIn = ObjectAnimator.ofFloat((Object)actionMenuView, (String)"alpha", (float[])new float[]{1.0f});
        if ((this.fabAttached || targetAttached && this.isVisibleFab()) && (this.fabAlignmentMode == 1 || targetMode == 1)) {
            ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)actionMenuView, (String)"alpha", (float[])new float[]{0.0f});
            fadeOut.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                public boolean cancelled;

                public void onAnimationCancel(Animator animation) {
                    this.cancelled = true;
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.cancelled) {
                        BottomAppBar.this.translateActionMenuView(actionMenuView, targetMode, targetAttached);
                    }
                }
            });
            AnimatorSet set = new AnimatorSet();
            set.setDuration(150L);
            set.playSequentially(new Animator[]{fadeOut, fadeIn});
            animators.add((Animator)set);
        } else if (actionMenuView.getAlpha() < 1.0f) {
            animators.add((Animator)fadeIn);
        }
    }

    private void maybeAnimateAttachChange(boolean targetAttached) {
        if (!ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (this.attachAnimator != null) {
            this.attachAnimator.cancel();
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        this.createCradleShapeAnimation(targetAttached && this.isVisibleFab(), animators);
        this.createFabTranslationYAnimation(targetAttached, animators);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        this.attachAnimator = set;
        this.attachAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BottomAppBar.this.attachAnimator = null;
            }
        });
        this.attachAnimator.start();
    }

    private void createCradleShapeAnimation(boolean showCradle, List<Animator> animators) {
        if (showCradle) {
            this.topEdgeTreatment.setHorizontalOffset(this.getFabTranslationX());
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.materialShapeDrawable.getInterpolation(), showCradle ? 1.0f : 0.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BottomAppBar.this.materialShapeDrawable.setInterpolation(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        animator.setDuration(300L);
        animators.add((Animator)animator);
    }

    private void createFabTranslationYAnimation(boolean targetAttached, List<Animator> animators) {
        FloatingActionButton fab = this.findDependentFab();
        if (fab == null) {
            return;
        }
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)fab, (String)"translationY", (float[])new float[]{this.getFabTranslationY(targetAttached)});
        animator.setDuration(300L);
        animators.add((Animator)animator);
    }

    private float getFabTranslationY(boolean targetAttached) {
        FloatingActionButton fab = this.findDependentFab();
        if (fab == null) {
            return 0.0f;
        }
        Rect fabContentRect = new Rect();
        fab.getContentRect(fabContentRect);
        float fabHeight = fabContentRect.height();
        if (fabHeight == 0.0f) {
            fabHeight = fab.getMeasuredHeight();
        }
        float fabBottomShadow = fab.getHeight() - fabContentRect.bottom;
        float fabVerticalShadowPadding = fab.getHeight() - fabContentRect.height();
        float attached = -this.getCradleVerticalOffset() + fabHeight / 2.0f + fabBottomShadow;
        float detached = fabVerticalShadowPadding - (float)fab.getPaddingBottom();
        return (float)(-this.getMeasuredHeight()) + (targetAttached ? attached : detached);
    }

    private float getFabTranslationY() {
        return this.getFabTranslationY(this.fabAttached);
    }

    private int getFabTranslationX(int fabAlignmentMode) {
        boolean isRtl;
        boolean bl = isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        return fabAlignmentMode == 1 ? (this.getMeasuredWidth() / 2 - this.fabOffsetEndMode) * (isRtl ? -1 : 1) : 0;
    }

    private float getFabTranslationX() {
        return this.getFabTranslationX(this.fabAlignmentMode);
    }

    @Nullable
    private ActionMenuView getActionMenuView() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof ActionMenuView)) continue;
            return (ActionMenuView)view;
        }
        return null;
    }

    private void translateActionMenuView(ActionMenuView actionMenuView, int fabAlignmentMode, boolean fabAttached) {
        int toolbarLeftContentEnd = 0;
        boolean isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean isAlignedToStart;
            View view = this.getChildAt(i);
            boolean bl = isAlignedToStart = view.getLayoutParams() instanceof Toolbar.LayoutParams && (((Toolbar.LayoutParams)view.getLayoutParams()).gravity & 0x800007) == 0x800003;
            if (!isAlignedToStart) continue;
            toolbarLeftContentEnd = Math.max(toolbarLeftContentEnd, isRtl ? view.getLeft() : view.getRight());
        }
        int end = isRtl ? actionMenuView.getRight() : actionMenuView.getLeft();
        int offset = toolbarLeftContentEnd - end;
        actionMenuView.setTranslationX(fabAlignmentMode == 1 && fabAttached ? (float)offset : 0.0f);
    }

    private void cancelAnimations() {
        if (this.attachAnimator != null) {
            this.attachAnimator.cancel();
        }
        if (this.menuAnimator != null) {
            this.menuAnimator.cancel();
        }
        if (this.modeAnimator != null) {
            this.modeAnimator.cancel();
        }
    }

    private boolean isAnimationRunning() {
        return this.attachAnimator != null && this.attachAnimator.isRunning() || this.menuAnimator != null && this.menuAnimator.isRunning() || this.modeAnimator != null && this.modeAnimator.isRunning();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.cancelAnimations();
        this.setCutoutState();
    }

    private void setCutoutState() {
        ActionMenuView actionMenuView;
        this.topEdgeTreatment.setHorizontalOffset(this.getFabTranslationX());
        FloatingActionButton fab = this.findDependentFab();
        this.materialShapeDrawable.setInterpolation(this.fabAttached && this.isVisibleFab() ? 1.0f : 0.0f);
        if (fab != null) {
            fab.setTranslationY(this.getFabTranslationY());
            fab.setTranslationX(this.getFabTranslationX());
        }
        if ((actionMenuView = this.getActionMenuView()) != null) {
            actionMenuView.setAlpha(1.0f);
            if (!this.isVisibleFab()) {
                this.translateActionMenuView(actionMenuView, 0, false);
            } else {
                this.translateActionMenuView(actionMenuView, this.fabAlignmentMode, this.fabAttached);
            }
        }
    }

    private void addFabAnimationListeners(@NonNull FloatingActionButton fab) {
        this.removeFabAnimationListeners(fab);
        fab.addOnHideAnimationListener((Animator.AnimatorListener)this.fabAnimationListener);
        fab.addOnShowAnimationListener((Animator.AnimatorListener)this.fabAnimationListener);
    }

    private void removeFabAnimationListeners(@NonNull FloatingActionButton fab) {
        fab.removeOnHideAnimationListener((Animator.AnimatorListener)this.fabAnimationListener);
        fab.removeOnShowAnimationListener((Animator.AnimatorListener)this.fabAnimationListener);
    }

    public void setTitle(CharSequence title) {
    }

    public void setSubtitle(CharSequence subtitle) {
    }

    @NonNull
    public CoordinatorLayout.Behavior<BottomAppBar> getBehavior() {
        return new Behavior();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.fabAlignmentMode = this.fabAlignmentMode;
        savedState.fabAttached = this.fabAttached;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.fabAlignmentMode = savedState.fabAlignmentMode;
        this.fabAttached = savedState.fabAttached;
    }

    static class SavedState
    extends AbsSavedState {
        int fabAlignmentMode;
        boolean fabAttached;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.fabAlignmentMode = in.readInt();
            this.fabAttached = in.readInt() != 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.fabAlignmentMode);
            out.writeInt(this.fabAttached ? 1 : 0);
        }
    }

    public static class Behavior
    extends HideBottomViewOnScrollBehavior<BottomAppBar> {
        private final Rect fabContentRect = new Rect();

        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        private boolean updateFabPositionAndVisibility(FloatingActionButton fab, BottomAppBar child) {
            CoordinatorLayout.LayoutParams fabLayoutParams = (CoordinatorLayout.LayoutParams)fab.getLayoutParams();
            fabLayoutParams.anchorGravity = 17;
            child.addFabAnimationListeners(fab);
            return true;
        }

        @Override
        public boolean onLayoutChild(CoordinatorLayout parent, BottomAppBar child, int layoutDirection) {
            FloatingActionButton fab = child.findDependentFab();
            if (fab != null) {
                this.updateFabPositionAndVisibility(fab, child);
                fab.getMeasuredContentRect(this.fabContentRect);
                child.setFabDiameter(this.fabContentRect.height());
            }
            if (!child.isAnimationRunning()) {
                child.setCutoutState();
            }
            parent.onLayoutChild((View)child, layoutDirection);
            return super.onLayoutChild(parent, child, layoutDirection);
        }

        public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull BottomAppBar child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
            return child.getHideOnScroll() && super.onStartNestedScroll(coordinatorLayout, (View)child, directTargetChild, target, axes, type);
        }

        @Override
        protected void slideUp(BottomAppBar child) {
            super.slideUp(child);
            FloatingActionButton fab = child.findDependentFab();
            if (fab != null) {
                fab.clearAnimation();
                fab.animate().translationY(child.getFabTranslationY()).setInterpolator(AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR).setDuration(225L);
            }
        }

        @Override
        protected void slideDown(BottomAppBar child) {
            super.slideDown(child);
            FloatingActionButton fab = child.findDependentFab();
            if (fab != null) {
                fab.getContentRect(this.fabContentRect);
                float fabShadowPadding = fab.getMeasuredHeight() - this.fabContentRect.height();
                fab.clearAnimation();
                fab.animate().translationY((float)(-fab.getPaddingBottom()) + fabShadowPadding).setInterpolator(AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR).setDuration(175L);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FabAlignmentMode {
    }
}

