/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.design.R;
import android.support.design.animation.AnimationUtils;
import android.support.design.internal.ThemeEnforcement;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.SnackbarManager;
import android.support.design.widget.SwipeDismissBehavior;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v4.view.accessibility.AccessibilityManagerCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.widget.FrameLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseTransientBottomBar<B extends BaseTransientBottomBar<B>> {
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    static final int ANIMATION_DURATION = 250;
    static final int ANIMATION_FADE_DURATION = 180;
    static final Handler handler;
    static final int MSG_SHOW = 0;
    static final int MSG_DISMISS = 1;
    private static final boolean USE_OFFSET_API;
    private static final int[] SNACKBAR_STYLE_ATTR;
    private final ViewGroup targetParent;
    private final Context context;
    protected final SnackbarBaseLayout view;
    private final android.support.design.snackbar.ContentViewCallback contentViewCallback;
    private int duration;
    private List<BaseCallback<B>> callbacks;
    private Behavior behavior;
    private final AccessibilityManager accessibilityManager;
    final SnackbarManager.Callback managerCallback = new SnackbarManager.Callback(){

        @Override
        public void show() {
            handler.sendMessage(handler.obtainMessage(0, (Object)BaseTransientBottomBar.this));
        }

        @Override
        public void dismiss(int event) {
            handler.sendMessage(handler.obtainMessage(1, event, 0, (Object)BaseTransientBottomBar.this));
        }
    };

    protected BaseTransientBottomBar(@NonNull ViewGroup parent, @NonNull View content, @NonNull android.support.design.snackbar.ContentViewCallback contentViewCallback) {
        if (parent == null) {
            throw new IllegalArgumentException("Transient bottom bar must have non-null parent");
        }
        if (content == null) {
            throw new IllegalArgumentException("Transient bottom bar must have non-null content");
        }
        if (contentViewCallback == null) {
            throw new IllegalArgumentException("Transient bottom bar must have non-null callback");
        }
        this.targetParent = parent;
        this.contentViewCallback = contentViewCallback;
        this.context = parent.getContext();
        ThemeEnforcement.checkAppCompatTheme(this.context);
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        this.view = (SnackbarBaseLayout)inflater.inflate(this.getSnackbarBaseLayoutResId(), this.targetParent, false);
        this.view.addView(content);
        ViewCompat.setAccessibilityLiveRegion((View)this.view, (int)1);
        ViewCompat.setImportantForAccessibility((View)this.view, (int)1);
        ViewCompat.setFitsSystemWindows((View)this.view, (boolean)true);
        ViewCompat.setOnApplyWindowInsetsListener((View)this.view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                v.setPadding(v.getPaddingLeft(), v.getPaddingTop(), v.getPaddingRight(), insets.getSystemWindowInsetBottom());
                return insets;
            }
        });
        ViewCompat.setAccessibilityDelegate((View)this.view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.addAction(0x100000);
                info.setDismissable(true);
            }

            public boolean performAccessibilityAction(View host, int action, Bundle args) {
                if (action == 0x100000) {
                    BaseTransientBottomBar.this.dismiss();
                    return true;
                }
                return super.performAccessibilityAction(host, action, args);
            }
        });
        this.accessibilityManager = (AccessibilityManager)this.context.getSystemService("accessibility");
    }

    @LayoutRes
    protected int getSnackbarBaseLayoutResId() {
        return this.hasSnackbarStyleAttr() ? R.layout.mtrl_layout_snackbar : R.layout.design_layout_snackbar;
    }

    protected boolean hasSnackbarStyleAttr() {
        TypedArray a = this.context.obtainStyledAttributes(SNACKBAR_STYLE_ATTR);
        int snackbarStyleResId = a.getResourceId(0, -1);
        a.recycle();
        return snackbarStyleResId != -1;
    }

    @NonNull
    public B setDuration(int duration) {
        this.duration = duration;
        return (B)this;
    }

    public int getDuration() {
        return this.duration;
    }

    public B setBehavior(Behavior behavior) {
        this.behavior = behavior;
        return (B)this;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    @NonNull
    public View getView() {
        return this.view;
    }

    public void show() {
        SnackbarManager.getInstance().show(this.getDuration(), this.managerCallback);
    }

    public void dismiss() {
        this.dispatchDismiss(3);
    }

    protected void dispatchDismiss(int event) {
        SnackbarManager.getInstance().dismiss(this.managerCallback, event);
    }

    @NonNull
    public B addCallback(@NonNull BaseCallback<B> callback) {
        if (callback == null) {
            return (B)this;
        }
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<BaseCallback<B>>();
        }
        this.callbacks.add(callback);
        return (B)this;
    }

    @NonNull
    public B removeCallback(@NonNull BaseCallback<B> callback) {
        if (callback == null) {
            return (B)this;
        }
        if (this.callbacks == null) {
            return (B)this;
        }
        this.callbacks.remove(callback);
        return (B)this;
    }

    public boolean isShown() {
        return SnackbarManager.getInstance().isCurrent(this.managerCallback);
    }

    public boolean isShownOrQueued() {
        return SnackbarManager.getInstance().isCurrentOrNext(this.managerCallback);
    }

    protected SwipeDismissBehavior<? extends View> getNewBehavior() {
        return new Behavior();
    }

    final void showView() {
        if (this.view.getParent() == null) {
            ViewGroup.LayoutParams lp = this.view.getLayoutParams();
            if (lp instanceof CoordinatorLayout.LayoutParams) {
                Behavior behavior;
                CoordinatorLayout.LayoutParams clp = (CoordinatorLayout.LayoutParams)lp;
                Behavior behavior2 = behavior = this.behavior == null ? this.getNewBehavior() : this.behavior;
                if (behavior instanceof Behavior) {
                    behavior.setBaseTransientBottomBar(this);
                }
                behavior.setListener(new SwipeDismissBehavior.OnDismissListener(){

                    @Override
                    public void onDismiss(View view) {
                        view.setVisibility(8);
                        BaseTransientBottomBar.this.dispatchDismiss(0);
                    }

                    @Override
                    public void onDragStateChanged(int state) {
                        switch (state) {
                            case 1: 
                            case 2: {
                                SnackbarManager.getInstance().pauseTimeout(BaseTransientBottomBar.this.managerCallback);
                                break;
                            }
                            case 0: {
                                SnackbarManager.getInstance().restoreTimeoutIfPaused(BaseTransientBottomBar.this.managerCallback);
                                break;
                            }
                        }
                    }
                });
                clp.setBehavior((CoordinatorLayout.Behavior)behavior);
                clp.insetEdge = 80;
            }
            this.targetParent.addView((View)this.view);
        }
        this.view.setOnAttachStateChangeListener(new OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View v) {
            }

            @Override
            public void onViewDetachedFromWindow(View v) {
                if (BaseTransientBottomBar.this.isShownOrQueued()) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseTransientBottomBar.this.onViewHidden(3);
                        }
                    });
                }
            }
        });
        if (ViewCompat.isLaidOut((View)this.view)) {
            if (this.shouldAnimate()) {
                this.animateViewIn();
            } else {
                this.onViewShown();
            }
        } else {
            this.view.setOnLayoutChangeListener(new OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(View view, int left, int top, int right, int bottom) {
                    BaseTransientBottomBar.this.view.setOnLayoutChangeListener(null);
                    if (BaseTransientBottomBar.this.shouldAnimate()) {
                        BaseTransientBottomBar.this.animateViewIn();
                    } else {
                        BaseTransientBottomBar.this.onViewShown();
                    }
                }
            });
        }
    }

    void animateViewIn() {
        final int translationYBottom = this.getTranslationYBottom();
        if (USE_OFFSET_API) {
            ViewCompat.offsetTopAndBottom((View)this.view, (int)translationYBottom);
        } else {
            this.view.setTranslationY(translationYBottom);
        }
        ValueAnimator animator2 = new ValueAnimator();
        animator2.setIntValues(new int[]{translationYBottom, 0});
        animator2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animator2.setDuration(250L);
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator2) {
                BaseTransientBottomBar.this.contentViewCallback.animateContentIn(70, 180);
            }

            public void onAnimationEnd(Animator animator2) {
                BaseTransientBottomBar.this.onViewShown();
            }
        });
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private int previousAnimatedIntValue;
            {
                this.previousAnimatedIntValue = translationYBottom;
            }

            public void onAnimationUpdate(ValueAnimator animator2) {
                int currentAnimatedIntValue = (Integer)animator2.getAnimatedValue();
                if (USE_OFFSET_API) {
                    ViewCompat.offsetTopAndBottom((View)BaseTransientBottomBar.this.view, (int)(currentAnimatedIntValue - this.previousAnimatedIntValue));
                } else {
                    BaseTransientBottomBar.this.view.setTranslationY(currentAnimatedIntValue);
                }
                this.previousAnimatedIntValue = currentAnimatedIntValue;
            }
        });
        animator2.start();
    }

    private void animateViewOut(final int event) {
        ValueAnimator animator2 = new ValueAnimator();
        animator2.setIntValues(new int[]{0, this.getTranslationYBottom()});
        animator2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animator2.setDuration(250L);
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator2) {
                BaseTransientBottomBar.this.contentViewCallback.animateContentOut(0, 180);
            }

            public void onAnimationEnd(Animator animator2) {
                BaseTransientBottomBar.this.onViewHidden(event);
            }
        });
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private int previousAnimatedIntValue = 0;

            public void onAnimationUpdate(ValueAnimator animator2) {
                int currentAnimatedIntValue = (Integer)animator2.getAnimatedValue();
                if (USE_OFFSET_API) {
                    ViewCompat.offsetTopAndBottom((View)BaseTransientBottomBar.this.view, (int)(currentAnimatedIntValue - this.previousAnimatedIntValue));
                } else {
                    BaseTransientBottomBar.this.view.setTranslationY(currentAnimatedIntValue);
                }
                this.previousAnimatedIntValue = currentAnimatedIntValue;
            }
        });
        animator2.start();
    }

    private int getTranslationYBottom() {
        int translationY = this.view.getHeight();
        ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            translationY += ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin;
        }
        return translationY;
    }

    final void hideView(int event) {
        if (this.shouldAnimate() && this.view.getVisibility() == 0) {
            this.animateViewOut(event);
        } else {
            this.onViewHidden(event);
        }
    }

    void onViewShown() {
        SnackbarManager.getInstance().onShown(this.managerCallback);
        if (this.callbacks != null) {
            int callbackCount = this.callbacks.size();
            for (int i = callbackCount - 1; i >= 0; --i) {
                this.callbacks.get(i).onShown(this);
            }
        }
    }

    void onViewHidden(int event) {
        ViewParent parent;
        SnackbarManager.getInstance().onDismissed(this.managerCallback);
        if (this.callbacks != null) {
            int callbackCount = this.callbacks.size();
            for (int i = callbackCount - 1; i >= 0; --i) {
                this.callbacks.get(i).onDismissed(this, event);
            }
        }
        if ((parent = this.view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this.view);
        }
    }

    boolean shouldAnimate() {
        boolean feedbackFlags = true;
        List serviceList = this.accessibilityManager.getEnabledAccessibilityServiceList(1);
        return serviceList != null && serviceList.isEmpty();
    }

    static {
        USE_OFFSET_API = Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 19;
        SNACKBAR_STYLE_ATTR = new int[]{R.attr.snackbarStyle};
        handler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                switch (message.what) {
                    case 0: {
                        ((BaseTransientBottomBar)message.obj).showView();
                        return true;
                    }
                    case 1: {
                        ((BaseTransientBottomBar)message.obj).hideView(message.arg1);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class BehaviorDelegate {
        private SnackbarManager.Callback managerCallback;

        public BehaviorDelegate(SwipeDismissBehavior<?> behavior) {
            behavior.setStartAlphaSwipeDistance(0.1f);
            behavior.setEndAlphaSwipeDistance(0.6f);
            behavior.setSwipeDirection(0);
        }

        public void setBaseTransientBottomBar(BaseTransientBottomBar<?> baseTransientBottomBar) {
            this.managerCallback = baseTransientBottomBar.managerCallback;
        }

        public boolean canSwipeDismissView(View child) {
            return child instanceof SnackbarBaseLayout;
        }

        public void onInterceptTouchEvent(CoordinatorLayout parent, View child, MotionEvent event) {
            switch (event.getActionMasked()) {
                case 0: {
                    if (!parent.isPointInChildBounds(child, (int)event.getX(), (int)event.getY())) break;
                    SnackbarManager.getInstance().pauseTimeout(this.managerCallback);
                    break;
                }
                case 1: 
                case 3: {
                    SnackbarManager.getInstance().restoreTimeoutIfPaused(this.managerCallback);
                    break;
                }
            }
        }
    }

    public static class Behavior
    extends SwipeDismissBehavior<View> {
        private final BehaviorDelegate delegate = new BehaviorDelegate(this);

        private void setBaseTransientBottomBar(BaseTransientBottomBar<?> baseTransientBottomBar) {
            this.delegate.setBaseTransientBottomBar(baseTransientBottomBar);
        }

        @Override
        public boolean canSwipeDismissView(View child) {
            return this.delegate.canSwipeDismissView(child);
        }

        @Override
        public boolean onInterceptTouchEvent(CoordinatorLayout parent, View child, MotionEvent event) {
            this.delegate.onInterceptTouchEvent(parent, child, event);
            return super.onInterceptTouchEvent(parent, child, event);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected static class SnackbarBaseLayout
    extends FrameLayout {
        private final AccessibilityManager accessibilityManager;
        private final AccessibilityManagerCompat.TouchExplorationStateChangeListener touchExplorationStateChangeListener;
        private OnLayoutChangeListener onLayoutChangeListener;
        private OnAttachStateChangeListener onAttachStateChangeListener;

        protected SnackbarBaseLayout(Context context) {
            this(context, null);
        }

        protected SnackbarBaseLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SnackbarLayout);
            if (a.hasValue(R.styleable.SnackbarLayout_elevation)) {
                ViewCompat.setElevation((View)this, (float)a.getDimensionPixelSize(R.styleable.SnackbarLayout_elevation, 0));
            }
            a.recycle();
            this.accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
            this.touchExplorationStateChangeListener = new AccessibilityManagerCompat.TouchExplorationStateChangeListener(){

                public void onTouchExplorationStateChanged(boolean enabled) {
                    SnackbarBaseLayout.this.setClickableOrFocusableBasedOnAccessibility(enabled);
                }
            };
            AccessibilityManagerCompat.addTouchExplorationStateChangeListener((AccessibilityManager)this.accessibilityManager, (AccessibilityManagerCompat.TouchExplorationStateChangeListener)this.touchExplorationStateChangeListener);
            this.setClickableOrFocusableBasedOnAccessibility(this.accessibilityManager.isTouchExplorationEnabled());
        }

        private void setClickableOrFocusableBasedOnAccessibility(boolean touchExplorationEnabled) {
            this.setClickable(!touchExplorationEnabled);
            this.setFocusable(touchExplorationEnabled);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.onLayoutChangeListener != null) {
                this.onLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
            }
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            if (this.onAttachStateChangeListener != null) {
                this.onAttachStateChangeListener.onViewAttachedToWindow((View)this);
            }
            ViewCompat.requestApplyInsets((View)this);
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.onAttachStateChangeListener != null) {
                this.onAttachStateChangeListener.onViewDetachedFromWindow((View)this);
            }
            AccessibilityManagerCompat.removeTouchExplorationStateChangeListener((AccessibilityManager)this.accessibilityManager, (AccessibilityManagerCompat.TouchExplorationStateChangeListener)this.touchExplorationStateChangeListener);
        }

        void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
            this.onLayoutChangeListener = onLayoutChangeListener;
        }

        void setOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
            this.onAttachStateChangeListener = listener;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected static interface OnAttachStateChangeListener {
        public void onViewAttachedToWindow(View var1);

        public void onViewDetachedFromWindow(View var1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected static interface OnLayoutChangeListener {
        public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=1L)
    public static @interface Duration {
    }

    @Deprecated
    public static interface ContentViewCallback
    extends android.support.design.snackbar.ContentViewCallback {
    }

    public static abstract class BaseCallback<B> {
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_TIMEOUT = 2;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;

        public void onDismissed(B transientBottomBar, int event) {
        }

        public void onShown(B transientBottomBar) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface DismissEvent {
        }
    }
}

