/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content.res;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Shader;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.content.res.ColorStateListInflaterCompat;
import android.support.v4.content.res.GradientColorInflaterCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ComplexColorCompat {
    private static final String LOG_TAG = "ComplexColorCompat";
    private final Shader mShader;
    private final ColorStateList mColorStateList;
    private int mColor;

    private ComplexColorCompat(Shader shader, ColorStateList colorStateList, @ColorInt int color2) {
        this.mShader = shader;
        this.mColorStateList = colorStateList;
        this.mColor = color2;
    }

    static ComplexColorCompat from(@NonNull Shader shader) {
        return new ComplexColorCompat(shader, null, 0);
    }

    static ComplexColorCompat from(@NonNull ColorStateList colorStateList) {
        return new ComplexColorCompat(null, colorStateList, colorStateList.getDefaultColor());
    }

    static ComplexColorCompat from(@ColorInt int color2) {
        return new ComplexColorCompat(null, null, color2);
    }

    @Nullable
    public Shader getShader() {
        return this.mShader;
    }

    @ColorInt
    public int getColor() {
        return this.mColor;
    }

    public void setColor(@ColorInt int color2) {
        this.mColor = color2;
    }

    public boolean isGradient() {
        return this.mShader != null;
    }

    public boolean isStateful() {
        return this.mShader == null && this.mColorStateList != null && this.mColorStateList.isStateful();
    }

    public boolean onStateChanged(int[] stateSet) {
        int colorForState;
        boolean changed = false;
        if (this.isStateful() && (colorForState = this.mColorStateList.getColorForState(stateSet, this.mColorStateList.getDefaultColor())) != this.mColor) {
            changed = true;
            this.mColor = colorForState;
        }
        return changed;
    }

    public boolean willDraw() {
        return this.isGradient() || this.mColor != 0;
    }

    @Nullable
    public static ComplexColorCompat inflate(@NonNull Resources resources, @ColorRes int resId, @Nullable Resources.Theme theme) {
        try {
            return ComplexColorCompat.createFromXml(resources, resId, theme);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Failed to inflate ComplexColor.", (Throwable)e);
            return null;
        }
    }

    @NonNull
    private static ComplexColorCompat createFromXml(@NonNull Resources resources, @ColorRes int resId, @Nullable Resources.Theme theme) throws IOException, XmlPullParserException {
        String name;
        int type;
        XmlResourceParser parser = resources.getXml(resId);
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        switch (name = parser.getName()) {
            case "selector": {
                return ComplexColorCompat.from(ColorStateListInflaterCompat.createFromXmlInner(resources, (XmlPullParser)parser, attrs, theme));
            }
            case "gradient": {
                return ComplexColorCompat.from(GradientColorInflaterCompat.createFromXmlInner(resources, (XmlPullParser)parser, attrs, theme));
            }
        }
        throw new XmlPullParserException(parser.getPositionDescription() + ": unsupported complex color tag " + name);
    }
}

