/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.os;

import android.os.Build;
import android.os.LocaleList;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.support.v4.os.LocaleHelper;
import android.support.v4.os.LocaleListHelper;
import android.support.v4.os.LocaleListInterface;
import java.util.Locale;

public final class LocaleListCompat {
    static final LocaleListInterface IMPL;
    private static final LocaleListCompat sEmptyLocaleList;

    private LocaleListCompat() {
    }

    @RequiresApi(value=24)
    public static LocaleListCompat wrap(Object object) {
        LocaleListCompat instance = new LocaleListCompat();
        if (object instanceof LocaleList) {
            instance.setLocaleList((LocaleList)object);
        }
        return instance;
    }

    @Nullable
    public Object unwrap() {
        return IMPL.getLocaleList();
    }

    public static LocaleListCompat create(Locale ... localeList) {
        LocaleListCompat instance = new LocaleListCompat();
        instance.setLocaleListArray(localeList);
        return instance;
    }

    public Locale get(int index) {
        return IMPL.get(index);
    }

    public boolean isEmpty() {
        return IMPL.isEmpty();
    }

    @IntRange(from=0L)
    public int size() {
        return IMPL.size();
    }

    @IntRange(from=-1L)
    public int indexOf(Locale locale) {
        return IMPL.indexOf(locale);
    }

    @NonNull
    public String toLanguageTags() {
        return IMPL.toLanguageTags();
    }

    public Locale getFirstMatch(String[] supportedLocales) {
        return IMPL.getFirstMatch(supportedLocales);
    }

    @NonNull
    public static LocaleListCompat getEmptyLocaleList() {
        return sEmptyLocaleList;
    }

    @NonNull
    public static LocaleListCompat forLanguageTags(@Nullable String list) {
        if (list == null || list.isEmpty()) {
            return LocaleListCompat.getEmptyLocaleList();
        }
        String[] tags = list.split(",", -1);
        Locale[] localeArray = new Locale[tags.length];
        for (int i = 0; i < localeArray.length; ++i) {
            localeArray[i] = Build.VERSION.SDK_INT >= 21 ? Locale.forLanguageTag(tags[i]) : LocaleHelper.forLanguageTag(tags[i]);
        }
        LocaleListCompat instance = new LocaleListCompat();
        instance.setLocaleListArray(localeArray);
        return instance;
    }

    @NonNull
    @Size(min=1L)
    public static LocaleListCompat getAdjustedDefault() {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleListCompat.wrap(LocaleList.getAdjustedDefault());
        }
        return LocaleListCompat.create(Locale.getDefault());
    }

    @NonNull
    @Size(min=1L)
    public static LocaleListCompat getDefault() {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleListCompat.wrap(LocaleList.getDefault());
        }
        return LocaleListCompat.create(Locale.getDefault());
    }

    public boolean equals(Object other) {
        return IMPL.equals(other);
    }

    public int hashCode() {
        return IMPL.hashCode();
    }

    public String toString() {
        return IMPL.toString();
    }

    @RequiresApi(value=24)
    private void setLocaleList(LocaleList localeList) {
        int localeListSize = localeList.size();
        if (localeListSize > 0) {
            Locale[] localeArrayList = new Locale[localeListSize];
            for (int i = 0; i < localeListSize; ++i) {
                localeArrayList[i] = localeList.get(i);
            }
            IMPL.setLocaleList(localeArrayList);
        }
    }

    private void setLocaleListArray(Locale ... localeArrayList) {
        IMPL.setLocaleList(localeArrayList);
    }

    static {
        sEmptyLocaleList = new LocaleListCompat();
        IMPL = Build.VERSION.SDK_INT >= 24 ? new LocaleListCompatApi24Impl() : new LocaleListCompatBaseImpl();
    }

    @RequiresApi(value=24)
    static class LocaleListCompatApi24Impl
    implements LocaleListInterface {
        private LocaleList mLocaleList = new LocaleList(new Locale[0]);

        LocaleListCompatApi24Impl() {
        }

        @Override
        public void setLocaleList(Locale ... list) {
            this.mLocaleList = new LocaleList(list);
        }

        @Override
        public Object getLocaleList() {
            return this.mLocaleList;
        }

        @Override
        public Locale get(int index) {
            return this.mLocaleList.get(index);
        }

        @Override
        public boolean isEmpty() {
            return this.mLocaleList.isEmpty();
        }

        @Override
        @IntRange(from=0L)
        public int size() {
            return this.mLocaleList.size();
        }

        @Override
        @IntRange(from=-1L)
        public int indexOf(Locale locale) {
            return this.mLocaleList.indexOf(locale);
        }

        @Override
        public boolean equals(Object other) {
            return this.mLocaleList.equals(((LocaleListCompat)other).unwrap());
        }

        @Override
        public int hashCode() {
            return this.mLocaleList.hashCode();
        }

        @Override
        public String toString() {
            return this.mLocaleList.toString();
        }

        @Override
        public String toLanguageTags() {
            return this.mLocaleList.toLanguageTags();
        }

        @Override
        @Nullable
        public Locale getFirstMatch(String[] supportedLocales) {
            if (this.mLocaleList != null) {
                return this.mLocaleList.getFirstMatch(supportedLocales);
            }
            return null;
        }
    }

    static class LocaleListCompatBaseImpl
    implements LocaleListInterface {
        private LocaleListHelper mLocaleList = new LocaleListHelper(new Locale[0]);

        LocaleListCompatBaseImpl() {
        }

        @Override
        public void setLocaleList(Locale ... list) {
            this.mLocaleList = new LocaleListHelper(list);
        }

        @Override
        public Object getLocaleList() {
            return this.mLocaleList;
        }

        @Override
        public Locale get(int index) {
            return this.mLocaleList.get(index);
        }

        @Override
        public boolean isEmpty() {
            return this.mLocaleList.isEmpty();
        }

        @Override
        @IntRange(from=0L)
        public int size() {
            return this.mLocaleList.size();
        }

        @Override
        @IntRange(from=-1L)
        public int indexOf(Locale locale) {
            return this.mLocaleList.indexOf(locale);
        }

        @Override
        public boolean equals(Object other) {
            return this.mLocaleList.equals(((LocaleListCompat)other).unwrap());
        }

        @Override
        public int hashCode() {
            return this.mLocaleList.hashCode();
        }

        @Override
        public String toString() {
            return this.mLocaleList.toString();
        }

        @Override
        public String toLanguageTags() {
            return this.mLocaleList.toLanguageTags();
        }

        @Override
        @Nullable
        public Locale getFirstMatch(String[] supportedLocales) {
            if (this.mLocaleList != null) {
                return this.mLocaleList.getFirstMatch(supportedLocales);
            }
            return null;
        }
    }
}

