/*
 * Decompiled with CFR 0.152.
 */
package androidx.versionedparcelable;

import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcelable;
import android.support.annotation.RestrictTo;
import android.util.SparseArray;
import androidx.versionedparcelable.VersionedParcel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class VersionedParcelStream
extends VersionedParcel {
    private static final Charset UTF_16 = Charset.forName("UTF-16");
    private static final int TYPE_NULL = 0;
    private static final int TYPE_SUB_BUNDLE = 1;
    private static final int TYPE_SUB_PERSISTABLE_BUNDLE = 2;
    private static final int TYPE_STRING = 3;
    private static final int TYPE_STRING_ARRAY = 4;
    private static final int TYPE_BOOLEAN = 5;
    private static final int TYPE_BOOLEAN_ARRAY = 6;
    private static final int TYPE_DOUBLE = 7;
    private static final int TYPE_DOUBLE_ARRAY = 8;
    private static final int TYPE_INT = 9;
    private static final int TYPE_INT_ARRAY = 10;
    private static final int TYPE_LONG = 11;
    private static final int TYPE_LONG_ARRAY = 12;
    private static final int TYPE_FLOAT = 13;
    private static final int TYPE_FLOAT_ARRAY = 14;
    private final DataInputStream mMasterInput;
    private final DataOutputStream mMasterOutput;
    private final SparseArray<InputBuffer> mCachedFields = new SparseArray();
    private DataInputStream mCurrentInput;
    private DataOutputStream mCurrentOutput;
    private FieldBuffer mFieldBuffer;
    private boolean mIgnoreParcelables;

    public VersionedParcelStream(InputStream input, OutputStream output) {
        this.mMasterInput = input != null ? new DataInputStream(input) : null;
        this.mMasterOutput = output != null ? new DataOutputStream(output) : null;
        this.mCurrentInput = this.mMasterInput;
        this.mCurrentOutput = this.mMasterOutput;
    }

    @Override
    public boolean isStream() {
        return true;
    }

    @Override
    public void setSerializationFlags(boolean allowSerialization, boolean ignoreParcelables) {
        if (!allowSerialization) {
            throw new RuntimeException("Serialization of this object is not allowed");
        }
        this.mIgnoreParcelables = ignoreParcelables;
    }

    @Override
    public void closeField() {
        if (this.mFieldBuffer != null) {
            try {
                if (this.mFieldBuffer.mOutput.size() != 0) {
                    this.mFieldBuffer.flushField();
                }
            }
            catch (IOException e) {
                throw new VersionedParcel.ParcelException(e);
            }
            this.mFieldBuffer = null;
        }
    }

    @Override
    protected VersionedParcel createSubParcel() {
        return new VersionedParcelStream(this.mCurrentInput, this.mCurrentOutput);
    }

    @Override
    public boolean readField(int fieldId) {
        InputBuffer buffer = (InputBuffer)this.mCachedFields.get(fieldId);
        if (buffer != null) {
            this.mCachedFields.remove(fieldId);
            this.mCurrentInput = buffer.mInputStream;
            return true;
        }
        try {
            while (true) {
                int fieldInfo;
                int size;
                if ((size = (fieldInfo = this.mMasterInput.readInt()) & 0xFFFF) == 65535) {
                    size = this.mMasterInput.readInt();
                }
                buffer = new InputBuffer(fieldInfo >> 16 & 0xFFFF, size, this.mMasterInput);
                if (buffer.mFieldId == fieldId) {
                    this.mCurrentInput = buffer.mInputStream;
                    return true;
                }
                this.mCachedFields.put(buffer.mFieldId, (Object)buffer);
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setOutputField(int fieldId) {
        this.closeField();
        this.mFieldBuffer = new FieldBuffer(fieldId, this.mMasterOutput);
        this.mCurrentOutput = this.mFieldBuffer.mDataStream;
    }

    @Override
    public void writeByteArray(byte[] b) {
        try {
            if (b != null) {
                this.mCurrentOutput.writeInt(b.length);
                this.mCurrentOutput.write(b);
            } else {
                this.mCurrentOutput.writeInt(-1);
            }
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeByteArray(byte[] b, int offset, int len) {
        try {
            if (b != null) {
                this.mCurrentOutput.writeInt(len);
                this.mCurrentOutput.write(b, offset, len);
            } else {
                this.mCurrentOutput.writeInt(-1);
            }
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeInt(int val) {
        try {
            this.mCurrentOutput.writeInt(val);
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeLong(long val) {
        try {
            this.mCurrentOutput.writeLong(val);
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeFloat(float val) {
        try {
            this.mCurrentOutput.writeFloat(val);
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeDouble(double val) {
        try {
            this.mCurrentOutput.writeDouble(val);
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeString(String val) {
        try {
            if (val != null) {
                byte[] bytes = val.getBytes(UTF_16);
                this.mCurrentOutput.writeInt(bytes.length);
                this.mCurrentOutput.write(bytes);
            } else {
                this.mCurrentOutput.writeInt(-1);
            }
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeBoolean(boolean val) {
        try {
            this.mCurrentOutput.writeBoolean(val);
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeStrongBinder(IBinder val) {
        if (!this.mIgnoreParcelables) {
            throw new RuntimeException("Binders cannot be written to an OutputStream");
        }
    }

    @Override
    public void writeParcelable(Parcelable p) {
        if (!this.mIgnoreParcelables) {
            throw new RuntimeException("Parcelables cannot be written to an OutputStream");
        }
    }

    @Override
    public void writeStrongInterface(IInterface val) {
        if (!this.mIgnoreParcelables) {
            throw new RuntimeException("Binders cannot be written to an OutputStream");
        }
    }

    @Override
    public IBinder readStrongBinder() {
        return null;
    }

    @Override
    public <T extends Parcelable> T readParcelable() {
        return null;
    }

    @Override
    public int readInt() {
        try {
            return this.mCurrentInput.readInt();
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.mCurrentInput.readLong();
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.mCurrentInput.readFloat();
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.mCurrentInput.readDouble();
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public String readString() {
        try {
            int len = this.mCurrentInput.readInt();
            if (len > 0) {
                byte[] bytes = new byte[len];
                this.mCurrentInput.readFully(bytes);
                return new String(bytes, UTF_16);
            }
            return null;
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public byte[] readByteArray() {
        try {
            int len = this.mCurrentInput.readInt();
            if (len > 0) {
                byte[] bytes = new byte[len];
                this.mCurrentInput.readFully(bytes);
                return bytes;
            }
            return null;
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.mCurrentInput.readBoolean();
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public void writeBundle(Bundle val) {
        try {
            if (val != null) {
                Set keys = val.keySet();
                this.mCurrentOutput.writeInt(keys.size());
                for (String key : keys) {
                    this.writeString(key);
                    Object o = val.get(key);
                    this.writeObject(o);
                }
            } else {
                this.mCurrentOutput.writeInt(-1);
            }
        }
        catch (IOException e) {
            throw new VersionedParcel.ParcelException(e);
        }
    }

    @Override
    public Bundle readBundle() {
        int size = this.readInt();
        if (size < 0) {
            return null;
        }
        Bundle b = new Bundle();
        for (int i = 0; i < size; ++i) {
            String key = this.readString();
            this.readObject(this.readInt(), key, b);
        }
        return b;
    }

    private void writeObject(Object o) {
        if (o == null) {
            this.writeInt(0);
        } else if (o instanceof Bundle) {
            this.writeInt(1);
            this.writeBundle((Bundle)o);
        } else if (o instanceof String) {
            this.writeInt(3);
            this.writeString((String)o);
        } else if (o instanceof String[]) {
            this.writeInt(4);
            this.writeArray((String[])o);
        } else if (o instanceof Boolean) {
            this.writeInt(5);
            this.writeBoolean((Boolean)o);
        } else if (o instanceof boolean[]) {
            this.writeInt(6);
            this.writeBooleanArray((boolean[])o);
        } else if (o instanceof Double) {
            this.writeInt(7);
            this.writeDouble((Double)o);
        } else if (o instanceof double[]) {
            this.writeInt(8);
            this.writeDoubleArray((double[])o);
        } else if (o instanceof Integer) {
            this.writeInt(9);
            this.writeInt((Integer)o);
        } else if (o instanceof int[]) {
            this.writeInt(10);
            this.writeIntArray((int[])o);
        } else if (o instanceof Long) {
            this.writeInt(11);
            this.writeLong((Long)o);
        } else if (o instanceof long[]) {
            this.writeInt(12);
            this.writeLongArray((long[])o);
        } else if (o instanceof Float) {
            this.writeInt(13);
            this.writeFloat(((Float)o).floatValue());
        } else if (o instanceof float[]) {
            this.writeInt(14);
            this.writeFloatArray((float[])o);
        } else {
            throw new IllegalArgumentException("Unsupported type " + o.getClass());
        }
    }

    private void readObject(int type, String key, Bundle b) {
        switch (type) {
            case 0: {
                b.putParcelable(key, null);
                break;
            }
            case 1: {
                b.putBundle(key, this.readBundle());
                break;
            }
            case 2: {
                b.putBundle(key, this.readBundle());
                break;
            }
            case 3: {
                b.putString(key, this.readString());
                break;
            }
            case 4: {
                b.putStringArray(key, this.readArray(new String[0]));
                break;
            }
            case 5: {
                b.putBoolean(key, this.readBoolean());
                break;
            }
            case 6: {
                b.putBooleanArray(key, this.readBooleanArray());
                break;
            }
            case 7: {
                b.putDouble(key, this.readDouble());
                break;
            }
            case 8: {
                b.putDoubleArray(key, this.readDoubleArray());
                break;
            }
            case 9: {
                b.putInt(key, this.readInt());
                break;
            }
            case 10: {
                b.putIntArray(key, this.readIntArray());
                break;
            }
            case 11: {
                b.putLong(key, this.readLong());
                break;
            }
            case 12: {
                b.putLongArray(key, this.readLongArray());
                break;
            }
            case 13: {
                b.putFloat(key, this.readFloat());
                break;
            }
            case 14: {
                b.putFloatArray(key, this.readFloatArray());
                break;
            }
            default: {
                throw new RuntimeException("Unknown type " + type);
            }
        }
    }

    private static class InputBuffer {
        final DataInputStream mInputStream;
        private final int mSize;
        final int mFieldId;

        InputBuffer(int fieldId, int size, DataInputStream inputStream) throws IOException {
            this.mSize = size;
            this.mFieldId = fieldId;
            byte[] data = new byte[this.mSize];
            inputStream.readFully(data);
            this.mInputStream = new DataInputStream(new ByteArrayInputStream(data));
        }
    }

    private static class FieldBuffer {
        final ByteArrayOutputStream mOutput = new ByteArrayOutputStream();
        final DataOutputStream mDataStream = new DataOutputStream(this.mOutput);
        private final int mFieldId;
        private final DataOutputStream mTarget;

        FieldBuffer(int fieldId, DataOutputStream target) {
            this.mFieldId = fieldId;
            this.mTarget = target;
        }

        void flushField() throws IOException {
            this.mDataStream.flush();
            int size = this.mOutput.size();
            int fieldInfo = this.mFieldId << 16 | (size >= 65535 ? 65535 : size);
            this.mTarget.writeInt(fieldInfo);
            if (size >= 65535) {
                this.mTarget.writeInt(size);
            }
            this.mOutput.writeTo(this.mTarget);
        }
    }
}

