/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.graphics.Rect;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.transition.AnimatorUtils;
import android.support.transition.PathMotion;
import android.support.transition.Styleable;
import android.support.transition.TransitionPropagation;
import android.support.transition.TransitionSet;
import android.support.transition.TransitionValues;
import android.support.transition.TransitionValuesMaps;
import android.support.transition.ViewUtils;
import android.support.transition.WindowIdImpl;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.LongSparseArray;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ListView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xmlpull.v1.XmlPullParser;

public abstract class Transition
implements Cloneable {
    private static final String LOG_TAG = "Transition";
    static final boolean DBG = false;
    public static final int MATCH_INSTANCE = 1;
    private static final int MATCH_FIRST = 1;
    public static final int MATCH_NAME = 2;
    public static final int MATCH_ID = 3;
    public static final int MATCH_ITEM_ID = 4;
    private static final int MATCH_LAST = 4;
    private static final String MATCH_INSTANCE_STR = "instance";
    private static final String MATCH_NAME_STR = "name";
    private static final String MATCH_ID_STR = "id";
    private static final String MATCH_ITEM_ID_STR = "itemId";
    private static final int[] DEFAULT_MATCH_ORDER = new int[]{2, 1, 3, 4};
    private static final PathMotion STRAIGHT_PATH_MOTION = new PathMotion(){

        @Override
        public Path getPath(float startX, float startY, float endX, float endY) {
            Path path = new Path();
            path.moveTo(startX, startY);
            path.lineTo(endX, endY);
            return path;
        }
    };
    private String mName = this.getClass().getName();
    private long mStartDelay = -1L;
    long mDuration = -1L;
    private TimeInterpolator mInterpolator = null;
    ArrayList<Integer> mTargetIds = new ArrayList();
    ArrayList<View> mTargets = new ArrayList();
    private ArrayList<String> mTargetNames = null;
    private ArrayList<Class> mTargetTypes = null;
    private ArrayList<Integer> mTargetIdExcludes = null;
    private ArrayList<View> mTargetExcludes = null;
    private ArrayList<Class> mTargetTypeExcludes = null;
    private ArrayList<String> mTargetNameExcludes = null;
    private ArrayList<Integer> mTargetIdChildExcludes = null;
    private ArrayList<View> mTargetChildExcludes = null;
    private ArrayList<Class> mTargetTypeChildExcludes = null;
    private TransitionValuesMaps mStartValues = new TransitionValuesMaps();
    private TransitionValuesMaps mEndValues = new TransitionValuesMaps();
    TransitionSet mParent = null;
    private int[] mMatchOrder = DEFAULT_MATCH_ORDER;
    private ArrayList<TransitionValues> mStartValuesList;
    private ArrayList<TransitionValues> mEndValuesList;
    private static ThreadLocal<ArrayMap<Animator, AnimationInfo>> sRunningAnimators = new ThreadLocal();
    private ViewGroup mSceneRoot = null;
    boolean mCanRemoveViews = false;
    ArrayList<Animator> mCurrentAnimators = new ArrayList();
    private int mNumInstances = 0;
    private boolean mPaused = false;
    private boolean mEnded = false;
    private ArrayList<TransitionListener> mListeners = null;
    private ArrayList<Animator> mAnimators = new ArrayList();
    TransitionPropagation mPropagation;
    private EpicenterCallback mEpicenterCallback;
    private ArrayMap<String, String> mNameOverrides;
    private PathMotion mPathMotion = STRAIGHT_PATH_MOTION;

    public Transition() {
    }

    public Transition(Context context, AttributeSet attrs) {
        String matchOrder;
        int resId;
        long startDelay;
        TypedArray a = context.obtainStyledAttributes(attrs, Styleable.TRANSITION);
        XmlResourceParser parser = (XmlResourceParser)attrs;
        long duration = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"duration", (int)1, (int)-1);
        if (duration >= 0L) {
            this.setDuration(duration);
        }
        if ((startDelay = (long)TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"startDelay", (int)2, (int)-1)) > 0L) {
            this.setStartDelay(startDelay);
        }
        if ((resId = TypedArrayUtils.getNamedResourceId((TypedArray)a, (XmlPullParser)parser, (String)"interpolator", (int)0, (int)0)) > 0) {
            this.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)context, (int)resId));
        }
        if ((matchOrder = TypedArrayUtils.getNamedString((TypedArray)a, (XmlPullParser)parser, (String)"matchOrder", (int)3)) != null) {
            this.setMatchOrder(Transition.parseMatchOrder(matchOrder));
        }
        a.recycle();
    }

    private static int[] parseMatchOrder(String matchOrderString) {
        StringTokenizer st = new StringTokenizer(matchOrderString, ",");
        int[] matches = new int[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (MATCH_ID_STR.equalsIgnoreCase(token)) {
                matches[index] = 3;
            } else if (MATCH_INSTANCE_STR.equalsIgnoreCase(token)) {
                matches[index] = 1;
            } else if (MATCH_NAME_STR.equalsIgnoreCase(token)) {
                matches[index] = 2;
            } else if (MATCH_ITEM_ID_STR.equalsIgnoreCase(token)) {
                matches[index] = 4;
            } else if (token.isEmpty()) {
                int[] smallerMatches = new int[matches.length - 1];
                System.arraycopy(matches, 0, smallerMatches, 0, index);
                matches = smallerMatches;
                --index;
            } else {
                throw new InflateException("Unknown match type in matchOrder: '" + token + "'");
            }
            ++index;
        }
        return matches;
    }

    @NonNull
    public Transition setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public long getDuration() {
        return this.mDuration;
    }

    @NonNull
    public Transition setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
        return this;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    @NonNull
    public Transition setInterpolator(@Nullable TimeInterpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    @Nullable
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    @Nullable
    public String[] getTransitionProperties() {
        return null;
    }

    @Nullable
    public Animator createAnimator(@NonNull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        return null;
    }

    public void setMatchOrder(int ... matches) {
        if (matches == null || matches.length == 0) {
            this.mMatchOrder = DEFAULT_MATCH_ORDER;
        } else {
            for (int i = 0; i < matches.length; ++i) {
                int match = matches[i];
                if (!Transition.isValidMatch(match)) {
                    throw new IllegalArgumentException("matches contains invalid value");
                }
                if (!Transition.alreadyContains(matches, i)) continue;
                throw new IllegalArgumentException("matches contains a duplicate value");
            }
            this.mMatchOrder = (int[])matches.clone();
        }
    }

    private static boolean isValidMatch(int match) {
        return match >= 1 && match <= 4;
    }

    private static boolean alreadyContains(int[] array, int searchIndex) {
        int value = array[searchIndex];
        for (int i = 0; i < searchIndex; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    private void matchInstances(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd) {
        for (int i = unmatchedStart.size() - 1; i >= 0; --i) {
            TransitionValues end;
            View view = (View)unmatchedStart.keyAt(i);
            if (view == null || !this.isValidTarget(view) || (end = (TransitionValues)unmatchedEnd.remove((Object)view)) == null || end.view == null || !this.isValidTarget(end.view)) continue;
            TransitionValues start = (TransitionValues)unmatchedStart.removeAt(i);
            this.mStartValuesList.add(start);
            this.mEndValuesList.add(end);
        }
    }

    private void matchItemIds(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, LongSparseArray<View> startItemIds, LongSparseArray<View> endItemIds) {
        int numStartIds = startItemIds.size();
        for (int i = 0; i < numStartIds; ++i) {
            View endView;
            View startView = (View)startItemIds.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = (View)endItemIds.get(startItemIds.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = (TransitionValues)unmatchedStart.get((Object)startView);
            TransitionValues endValues = (TransitionValues)unmatchedEnd.get((Object)endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove((Object)startView);
            unmatchedEnd.remove((Object)endView);
        }
    }

    private void matchIds(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, SparseArray<View> startIds, SparseArray<View> endIds) {
        int numStartIds = startIds.size();
        for (int i = 0; i < numStartIds; ++i) {
            View endView;
            View startView = (View)startIds.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = (View)endIds.get(startIds.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = (TransitionValues)unmatchedStart.get((Object)startView);
            TransitionValues endValues = (TransitionValues)unmatchedEnd.get((Object)endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove((Object)startView);
            unmatchedEnd.remove((Object)endView);
        }
    }

    private void matchNames(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, ArrayMap<String, View> startNames, ArrayMap<String, View> endNames) {
        int numStartNames = startNames.size();
        for (int i = 0; i < numStartNames; ++i) {
            View endView;
            View startView = (View)startNames.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = (View)endNames.get(startNames.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = (TransitionValues)unmatchedStart.get((Object)startView);
            TransitionValues endValues = (TransitionValues)unmatchedEnd.get((Object)endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove((Object)startView);
            unmatchedEnd.remove((Object)endView);
        }
    }

    private void addUnmatched(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd) {
        int i;
        for (i = 0; i < unmatchedStart.size(); ++i) {
            TransitionValues start = (TransitionValues)unmatchedStart.valueAt(i);
            if (!this.isValidTarget(start.view)) continue;
            this.mStartValuesList.add(start);
            this.mEndValuesList.add(null);
        }
        for (i = 0; i < unmatchedEnd.size(); ++i) {
            TransitionValues end = (TransitionValues)unmatchedEnd.valueAt(i);
            if (!this.isValidTarget(end.view)) continue;
            this.mEndValuesList.add(end);
            this.mStartValuesList.add(null);
        }
    }

    private void matchStartAndEnd(TransitionValuesMaps startValues, TransitionValuesMaps endValues) {
        ArrayMap unmatchedStart = new ArrayMap(startValues.mViewValues);
        ArrayMap unmatchedEnd = new ArrayMap(endValues.mViewValues);
        block6: for (int i = 0; i < this.mMatchOrder.length; ++i) {
            switch (this.mMatchOrder[i]) {
                case 1: {
                    this.matchInstances((ArrayMap<View, TransitionValues>)unmatchedStart, (ArrayMap<View, TransitionValues>)unmatchedEnd);
                    continue block6;
                }
                case 2: {
                    this.matchNames((ArrayMap<View, TransitionValues>)unmatchedStart, (ArrayMap<View, TransitionValues>)unmatchedEnd, startValues.mNameValues, endValues.mNameValues);
                    continue block6;
                }
                case 3: {
                    this.matchIds((ArrayMap<View, TransitionValues>)unmatchedStart, (ArrayMap<View, TransitionValues>)unmatchedEnd, startValues.mIdValues, endValues.mIdValues);
                    continue block6;
                }
                case 4: {
                    this.matchItemIds((ArrayMap<View, TransitionValues>)unmatchedStart, (ArrayMap<View, TransitionValues>)unmatchedEnd, startValues.mItemIdValues, endValues.mItemIdValues);
                }
            }
        }
        this.addUnmatched((ArrayMap<View, TransitionValues>)unmatchedStart, (ArrayMap<View, TransitionValues>)unmatchedEnd);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void createAnimators(ViewGroup sceneRoot, TransitionValuesMaps startValues, TransitionValuesMaps endValues, ArrayList<TransitionValues> startValuesList, ArrayList<TransitionValues> endValuesList) {
        int i;
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        long minStartDelay = Long.MAX_VALUE;
        SparseIntArray startDelays = new SparseIntArray();
        int startValuesListCount = startValuesList.size();
        for (i = 0; i < startValuesListCount; ++i) {
            View view;
            Animator animator;
            boolean isChanged;
            TransitionValues start = startValuesList.get(i);
            TransitionValues end = endValuesList.get(i);
            if (start != null && !start.mTargetedTransitions.contains(this)) {
                start = null;
            }
            if (end != null && !end.mTargetedTransitions.contains(this)) {
                end = null;
            }
            if (start == null && end == null) continue;
            boolean bl = isChanged = start == null || end == null || this.isTransitionRequired(start, end);
            if (!isChanged || (animator = this.createAnimator(sceneRoot, start, end)) == null) continue;
            TransitionValues infoValues = null;
            if (end != null) {
                view = end.view;
                String[] properties = this.getTransitionProperties();
                if (view != null && properties != null && properties.length > 0) {
                    infoValues = new TransitionValues();
                    infoValues.view = view;
                    TransitionValues newValues = (TransitionValues)endValues.mViewValues.get((Object)view);
                    if (newValues != null) {
                        for (int j = 0; j < properties.length; ++j) {
                            infoValues.values.put(properties[j], newValues.values.get(properties[j]));
                        }
                    }
                    int numExistingAnims = runningAnimators.size();
                    for (int j = 0; j < numExistingAnims; ++j) {
                        Animator anim = (Animator)runningAnimators.keyAt(j);
                        AnimationInfo info = (AnimationInfo)runningAnimators.get((Object)anim);
                        if (info.mValues == null || info.mView != view || !info.mName.equals(this.getName()) || !info.mValues.equals(infoValues)) continue;
                        animator = null;
                        break;
                    }
                }
            } else {
                view = start.view;
            }
            if (animator == null) continue;
            if (this.mPropagation != null) {
                long delay = this.mPropagation.getStartDelay(sceneRoot, this, start, end);
                startDelays.put(this.mAnimators.size(), (int)delay);
                minStartDelay = Math.min(delay, minStartDelay);
            }
            AnimationInfo info = new AnimationInfo(view, this.getName(), this, ViewUtils.getWindowId((View)sceneRoot), infoValues);
            runningAnimators.put((Object)animator, (Object)info);
            this.mAnimators.add(animator);
        }
        if (minStartDelay != 0L) {
            for (i = 0; i < startDelays.size(); ++i) {
                int index = startDelays.keyAt(i);
                Animator animator = this.mAnimators.get(index);
                long delay = (long)startDelays.valueAt(i) - minStartDelay + animator.getStartDelay();
                animator.setStartDelay(delay);
            }
        }
    }

    boolean isValidTarget(View target) {
        int targetId = target.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(targetId)) {
            return false;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(target)) {
            return false;
        }
        if (this.mTargetTypeExcludes != null) {
            int numTypes = this.mTargetTypeExcludes.size();
            for (int i = 0; i < numTypes; ++i) {
                Class type = this.mTargetTypeExcludes.get(i);
                if (!type.isInstance(target)) continue;
                return false;
            }
        }
        if (this.mTargetNameExcludes != null && ViewCompat.getTransitionName((View)target) != null && this.mTargetNameExcludes.contains(ViewCompat.getTransitionName((View)target))) {
            return false;
        }
        if (this.mTargetIds.size() == 0 && this.mTargets.size() == 0 && (this.mTargetTypes == null || this.mTargetTypes.isEmpty()) && (this.mTargetNames == null || this.mTargetNames.isEmpty())) {
            return true;
        }
        if (this.mTargetIds.contains(targetId) || this.mTargets.contains(target)) {
            return true;
        }
        if (this.mTargetNames != null && this.mTargetNames.contains(ViewCompat.getTransitionName((View)target))) {
            return true;
        }
        if (this.mTargetTypes != null) {
            for (int i = 0; i < this.mTargetTypes.size(); ++i) {
                if (!this.mTargetTypes.get(i).isInstance(target)) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayMap<Animator, AnimationInfo> getRunningAnimators() {
        ArrayMap runningAnimators = sRunningAnimators.get();
        if (runningAnimators == null) {
            runningAnimators = new ArrayMap();
            sRunningAnimators.set((ArrayMap<Animator, AnimationInfo>)runningAnimators);
        }
        return runningAnimators;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void runAnimators() {
        this.start();
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        for (Animator anim : this.mAnimators) {
            if (!runningAnimators.containsKey((Object)anim)) continue;
            this.start();
            this.runAnimator(anim, runningAnimators);
        }
        this.mAnimators.clear();
        this.end();
    }

    private void runAnimator(Animator animator, final ArrayMap<Animator, AnimationInfo> runningAnimators) {
        if (animator != null) {
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    Transition.this.mCurrentAnimators.add(animation);
                }

                public void onAnimationEnd(Animator animation) {
                    runningAnimators.remove((Object)animation);
                    Transition.this.mCurrentAnimators.remove(animation);
                }
            });
            this.animate(animator);
        }
    }

    public abstract void captureStartValues(@NonNull TransitionValues var1);

    public abstract void captureEndValues(@NonNull TransitionValues var1);

    @NonNull
    public Transition addTarget(@NonNull View target) {
        this.mTargets.add(target);
        return this;
    }

    @NonNull
    public Transition addTarget(@IdRes int targetId) {
        if (targetId != 0) {
            this.mTargetIds.add(targetId);
        }
        return this;
    }

    @NonNull
    public Transition addTarget(@NonNull String targetName) {
        if (this.mTargetNames == null) {
            this.mTargetNames = new ArrayList();
        }
        this.mTargetNames.add(targetName);
        return this;
    }

    @NonNull
    public Transition addTarget(@NonNull Class targetType) {
        if (this.mTargetTypes == null) {
            this.mTargetTypes = new ArrayList();
        }
        this.mTargetTypes.add(targetType);
        return this;
    }

    @NonNull
    public Transition removeTarget(@NonNull View target) {
        this.mTargets.remove(target);
        return this;
    }

    @NonNull
    public Transition removeTarget(@IdRes int targetId) {
        if (targetId != 0) {
            this.mTargetIds.remove((Object)targetId);
        }
        return this;
    }

    @NonNull
    public Transition removeTarget(@NonNull String targetName) {
        if (this.mTargetNames != null) {
            this.mTargetNames.remove(targetName);
        }
        return this;
    }

    @NonNull
    public Transition removeTarget(@NonNull Class target) {
        if (this.mTargetTypes != null) {
            this.mTargetTypes.remove(target);
        }
        return this;
    }

    private static <T> ArrayList<T> excludeObject(ArrayList<T> list, T target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    @NonNull
    public Transition excludeTarget(@NonNull View target, boolean exclude) {
        this.mTargetExcludes = this.excludeView(this.mTargetExcludes, target, exclude);
        return this;
    }

    @NonNull
    public Transition excludeTarget(@IdRes int targetId, boolean exclude) {
        this.mTargetIdExcludes = this.excludeId(this.mTargetIdExcludes, targetId, exclude);
        return this;
    }

    @NonNull
    public Transition excludeTarget(@NonNull String targetName, boolean exclude) {
        this.mTargetNameExcludes = Transition.excludeObject(this.mTargetNameExcludes, targetName, exclude);
        return this;
    }

    @NonNull
    public Transition excludeChildren(@NonNull View target, boolean exclude) {
        this.mTargetChildExcludes = this.excludeView(this.mTargetChildExcludes, target, exclude);
        return this;
    }

    @NonNull
    public Transition excludeChildren(@IdRes int targetId, boolean exclude) {
        this.mTargetIdChildExcludes = this.excludeId(this.mTargetIdChildExcludes, targetId, exclude);
        return this;
    }

    private ArrayList<Integer> excludeId(ArrayList<Integer> list, int targetId, boolean exclude) {
        if (targetId > 0) {
            list = exclude ? ArrayListManager.add(list, targetId) : ArrayListManager.remove(list, targetId);
        }
        return list;
    }

    private ArrayList<View> excludeView(ArrayList<View> list, View target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    @NonNull
    public Transition excludeTarget(@NonNull Class type, boolean exclude) {
        this.mTargetTypeExcludes = this.excludeType(this.mTargetTypeExcludes, type, exclude);
        return this;
    }

    @NonNull
    public Transition excludeChildren(@NonNull Class type, boolean exclude) {
        this.mTargetTypeChildExcludes = this.excludeType(this.mTargetTypeChildExcludes, type, exclude);
        return this;
    }

    private ArrayList<Class> excludeType(ArrayList<Class> list, Class type, boolean exclude) {
        if (type != null) {
            list = exclude ? ArrayListManager.add(list, type) : ArrayListManager.remove(list, type);
        }
        return list;
    }

    @NonNull
    public List<Integer> getTargetIds() {
        return this.mTargetIds;
    }

    @NonNull
    public List<View> getTargets() {
        return this.mTargets;
    }

    @Nullable
    public List<String> getTargetNames() {
        return this.mTargetNames;
    }

    @Nullable
    public List<Class> getTargetTypes() {
        return this.mTargetTypes;
    }

    void captureValues(ViewGroup sceneRoot, boolean start) {
        this.clearValues(start);
        if (!(this.mTargetIds.size() <= 0 && this.mTargets.size() <= 0 || this.mTargetNames != null && !this.mTargetNames.isEmpty() || this.mTargetTypes != null && !this.mTargetTypes.isEmpty())) {
            int i;
            for (i = 0; i < this.mTargetIds.size(); ++i) {
                int id2 = this.mTargetIds.get(i);
                View view = sceneRoot.findViewById(id2);
                if (view == null) continue;
                TransitionValues values = new TransitionValues();
                values.view = view;
                if (start) {
                    this.captureStartValues(values);
                } else {
                    this.captureEndValues(values);
                }
                values.mTargetedTransitions.add(this);
                this.capturePropagationValues(values);
                if (start) {
                    Transition.addViewValues(this.mStartValues, view, values);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, values);
            }
            for (i = 0; i < this.mTargets.size(); ++i) {
                View view = this.mTargets.get(i);
                TransitionValues values = new TransitionValues();
                values.view = view;
                if (start) {
                    this.captureStartValues(values);
                } else {
                    this.captureEndValues(values);
                }
                values.mTargetedTransitions.add(this);
                this.capturePropagationValues(values);
                if (start) {
                    Transition.addViewValues(this.mStartValues, view, values);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, values);
            }
        } else {
            this.captureHierarchy((View)sceneRoot, start);
        }
        if (!start && this.mNameOverrides != null) {
            int i;
            int numOverrides = this.mNameOverrides.size();
            ArrayList<Object> overriddenViews = new ArrayList<Object>(numOverrides);
            for (i = 0; i < numOverrides; ++i) {
                String fromName = (String)this.mNameOverrides.keyAt(i);
                overriddenViews.add(this.mStartValues.mNameValues.remove((Object)fromName));
            }
            for (i = 0; i < numOverrides; ++i) {
                View view = (View)overriddenViews.get(i);
                if (view == null) continue;
                String toName = (String)this.mNameOverrides.valueAt(i);
                this.mStartValues.mNameValues.put((Object)toName, (Object)view);
            }
        }
    }

    private static void addViewValues(TransitionValuesMaps transitionValuesMaps, View view, TransitionValues transitionValues) {
        ListView listview;
        String name;
        transitionValuesMaps.mViewValues.put((Object)view, (Object)transitionValues);
        int id2 = view.getId();
        if (id2 >= 0) {
            if (transitionValuesMaps.mIdValues.indexOfKey(id2) >= 0) {
                transitionValuesMaps.mIdValues.put(id2, null);
            } else {
                transitionValuesMaps.mIdValues.put(id2, (Object)view);
            }
        }
        if ((name = ViewCompat.getTransitionName((View)view)) != null) {
            if (transitionValuesMaps.mNameValues.containsKey((Object)name)) {
                transitionValuesMaps.mNameValues.put((Object)name, null);
            } else {
                transitionValuesMaps.mNameValues.put((Object)name, (Object)view);
            }
        }
        if (view.getParent() instanceof ListView && (listview = (ListView)view.getParent()).getAdapter().hasStableIds()) {
            int position = listview.getPositionForView(view);
            long itemId = listview.getItemIdAtPosition(position);
            if (transitionValuesMaps.mItemIdValues.indexOfKey(itemId) >= 0) {
                View alreadyMatched = (View)transitionValuesMaps.mItemIdValues.get(itemId);
                if (alreadyMatched != null) {
                    ViewCompat.setHasTransientState((View)alreadyMatched, (boolean)false);
                    transitionValuesMaps.mItemIdValues.put(itemId, null);
                }
            } else {
                ViewCompat.setHasTransientState((View)view, (boolean)true);
                transitionValuesMaps.mItemIdValues.put(itemId, (Object)view);
            }
        }
    }

    void clearValues(boolean start) {
        if (start) {
            this.mStartValues.mViewValues.clear();
            this.mStartValues.mIdValues.clear();
            this.mStartValues.mItemIdValues.clear();
        } else {
            this.mEndValues.mViewValues.clear();
            this.mEndValues.mIdValues.clear();
            this.mEndValues.mItemIdValues.clear();
        }
    }

    private void captureHierarchy(View view, boolean start) {
        int i;
        int numTypes;
        if (view == null) {
            return;
        }
        int id2 = view.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(id2)) {
            return;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(view)) {
            return;
        }
        if (this.mTargetTypeExcludes != null) {
            numTypes = this.mTargetTypeExcludes.size();
            for (i = 0; i < numTypes; ++i) {
                if (!this.mTargetTypeExcludes.get(i).isInstance(view)) continue;
                return;
            }
        }
        if (view.getParent() instanceof ViewGroup) {
            TransitionValues values = new TransitionValues();
            values.view = view;
            if (start) {
                this.captureStartValues(values);
            } else {
                this.captureEndValues(values);
            }
            values.mTargetedTransitions.add(this);
            this.capturePropagationValues(values);
            if (start) {
                Transition.addViewValues(this.mStartValues, view, values);
            } else {
                Transition.addViewValues(this.mEndValues, view, values);
            }
        }
        if (view instanceof ViewGroup) {
            if (this.mTargetIdChildExcludes != null && this.mTargetIdChildExcludes.contains(id2)) {
                return;
            }
            if (this.mTargetChildExcludes != null && this.mTargetChildExcludes.contains(view)) {
                return;
            }
            if (this.mTargetTypeChildExcludes != null) {
                numTypes = this.mTargetTypeChildExcludes.size();
                for (i = 0; i < numTypes; ++i) {
                    if (!this.mTargetTypeChildExcludes.get(i).isInstance(view)) continue;
                    return;
                }
            }
            ViewGroup parent = (ViewGroup)view;
            for (i = 0; i < parent.getChildCount(); ++i) {
                this.captureHierarchy(parent.getChildAt(i), start);
            }
        }
    }

    @Nullable
    public TransitionValues getTransitionValues(@NonNull View view, boolean start) {
        if (this.mParent != null) {
            return this.mParent.getTransitionValues(view, start);
        }
        TransitionValuesMaps valuesMaps = start ? this.mStartValues : this.mEndValues;
        return (TransitionValues)valuesMaps.mViewValues.get((Object)view);
    }

    TransitionValues getMatchedTransitionValues(View view, boolean viewInStart) {
        ArrayList<TransitionValues> lookIn;
        if (this.mParent != null) {
            return this.mParent.getMatchedTransitionValues(view, viewInStart);
        }
        ArrayList<TransitionValues> arrayList = lookIn = viewInStart ? this.mStartValuesList : this.mEndValuesList;
        if (lookIn == null) {
            return null;
        }
        int count = lookIn.size();
        int index = -1;
        for (int i = 0; i < count; ++i) {
            TransitionValues values = lookIn.get(i);
            if (values == null) {
                return null;
            }
            if (values.view != view) continue;
            index = i;
            break;
        }
        TransitionValues values = null;
        if (index >= 0) {
            ArrayList<TransitionValues> matchIn = viewInStart ? this.mEndValuesList : this.mStartValuesList;
            values = matchIn.get(index);
        }
        return values;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void pause(View sceneRoot) {
        if (!this.mEnded) {
            ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
            int numOldAnims = runningAnimators.size();
            WindowIdImpl windowId = ViewUtils.getWindowId(sceneRoot);
            for (int i = numOldAnims - 1; i >= 0; --i) {
                AnimationInfo info = (AnimationInfo)runningAnimators.valueAt(i);
                if (info.mView == null || !windowId.equals(info.mWindowId)) continue;
                Animator anim = (Animator)runningAnimators.keyAt(i);
                AnimatorUtils.pause(anim);
            }
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((TransitionListener)tmpListeners.get(i)).onTransitionPause(this);
                }
            }
            this.mPaused = true;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void resume(View sceneRoot) {
        if (this.mPaused) {
            if (!this.mEnded) {
                ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
                int numOldAnims = runningAnimators.size();
                WindowIdImpl windowId = ViewUtils.getWindowId(sceneRoot);
                for (int i = numOldAnims - 1; i >= 0; --i) {
                    AnimationInfo info = (AnimationInfo)runningAnimators.valueAt(i);
                    if (info.mView == null || !windowId.equals(info.mWindowId)) continue;
                    Animator anim = (Animator)runningAnimators.keyAt(i);
                    AnimatorUtils.resume(anim);
                }
                if (this.mListeners != null && this.mListeners.size() > 0) {
                    ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                    int numListeners = tmpListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((TransitionListener)tmpListeners.get(i)).onTransitionResume(this);
                    }
                }
            }
            this.mPaused = false;
        }
    }

    void playTransition(ViewGroup sceneRoot) {
        this.mStartValuesList = new ArrayList();
        this.mEndValuesList = new ArrayList();
        this.matchStartAndEnd(this.mStartValues, this.mEndValues);
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        int numOldAnims = runningAnimators.size();
        WindowIdImpl windowId = ViewUtils.getWindowId((View)sceneRoot);
        for (int i = numOldAnims - 1; i >= 0; --i) {
            boolean cancel;
            AnimationInfo oldInfo;
            Animator anim = (Animator)runningAnimators.keyAt(i);
            if (anim == null || (oldInfo = (AnimationInfo)runningAnimators.get((Object)anim)) == null || oldInfo.mView == null || !windowId.equals(oldInfo.mWindowId)) continue;
            TransitionValues oldValues = oldInfo.mValues;
            View oldView = oldInfo.mView;
            TransitionValues startValues = this.getTransitionValues(oldView, true);
            TransitionValues endValues = this.getMatchedTransitionValues(oldView, true);
            boolean bl = cancel = (startValues != null || endValues != null) && oldInfo.mTransition.isTransitionRequired(oldValues, endValues);
            if (!cancel) continue;
            if (anim.isRunning() || anim.isStarted()) {
                anim.cancel();
                continue;
            }
            runningAnimators.remove((Object)anim);
        }
        this.createAnimators(sceneRoot, this.mStartValues, this.mEndValues, this.mStartValuesList, this.mEndValuesList);
        this.runAnimators();
    }

    public boolean isTransitionRequired(@Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        boolean valuesChanged;
        block4: {
            valuesChanged = false;
            if (startValues == null || endValues == null) break block4;
            String[] properties = this.getTransitionProperties();
            if (properties != null) {
                for (String property : properties) {
                    if (!Transition.isValueChanged(startValues, endValues, property)) continue;
                    valuesChanged = true;
                    break;
                }
            } else {
                for (String key : startValues.values.keySet()) {
                    if (!Transition.isValueChanged(startValues, endValues, key)) continue;
                    valuesChanged = true;
                    break;
                }
            }
        }
        return valuesChanged;
    }

    private static boolean isValueChanged(TransitionValues oldValues, TransitionValues newValues, String key) {
        Object oldValue = oldValues.values.get(key);
        Object newValue = newValues.values.get(key);
        boolean changed = oldValue == null && newValue == null ? false : (oldValue == null || newValue == null ? true : !oldValue.equals(newValue));
        return changed;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void animate(Animator animator) {
        if (animator == null) {
            this.end();
        } else {
            if (this.getDuration() >= 0L) {
                animator.setDuration(this.getDuration());
            }
            if (this.getStartDelay() >= 0L) {
                animator.setStartDelay(this.getStartDelay());
            }
            if (this.getInterpolator() != null) {
                animator.setInterpolator(this.getInterpolator());
            }
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    Transition.this.end();
                    animation.removeListener((Animator.AnimatorListener)this);
                }
            });
            animator.start();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void start() {
        if (this.mNumInstances == 0) {
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((TransitionListener)tmpListeners.get(i)).onTransitionStart(this);
                }
            }
            this.mEnded = false;
        }
        ++this.mNumInstances;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void end() {
        --this.mNumInstances;
        if (this.mNumInstances == 0) {
            int i;
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i2 = 0; i2 < numListeners; ++i2) {
                    ((TransitionListener)tmpListeners.get(i2)).onTransitionEnd(this);
                }
            }
            for (i = 0; i < this.mStartValues.mItemIdValues.size(); ++i) {
                View view = (View)this.mStartValues.mItemIdValues.valueAt(i);
                if (view == null) continue;
                ViewCompat.setHasTransientState((View)view, (boolean)false);
            }
            for (i = 0; i < this.mEndValues.mItemIdValues.size(); ++i) {
                View view = (View)this.mEndValues.mItemIdValues.valueAt(i);
                if (view == null) continue;
                ViewCompat.setHasTransientState((View)view, (boolean)false);
            }
            this.mEnded = true;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void forceToEnd(ViewGroup sceneRoot) {
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        int numOldAnims = runningAnimators.size();
        if (sceneRoot != null) {
            WindowIdImpl windowId = ViewUtils.getWindowId((View)sceneRoot);
            for (int i = numOldAnims - 1; i >= 0; --i) {
                AnimationInfo info = (AnimationInfo)runningAnimators.valueAt(i);
                if (info.mView == null || windowId == null || !windowId.equals(info.mWindowId)) continue;
                Animator anim = (Animator)runningAnimators.keyAt(i);
                anim.end();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void cancel() {
        int numAnimators = this.mCurrentAnimators.size();
        for (int i = numAnimators - 1; i >= 0; --i) {
            Animator animator = this.mCurrentAnimators.get(i);
            animator.cancel();
        }
        if (this.mListeners != null && this.mListeners.size() > 0) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((TransitionListener)tmpListeners.get(i)).onTransitionCancel(this);
            }
        }
    }

    @NonNull
    public Transition addListener(@NonNull TransitionListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
        return this;
    }

    @NonNull
    public Transition removeListener(@NonNull TransitionListener listener) {
        if (this.mListeners == null) {
            return this;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
        return this;
    }

    public void setPathMotion(@Nullable PathMotion pathMotion) {
        this.mPathMotion = pathMotion == null ? STRAIGHT_PATH_MOTION : pathMotion;
    }

    @NonNull
    public PathMotion getPathMotion() {
        return this.mPathMotion;
    }

    public void setEpicenterCallback(@Nullable EpicenterCallback epicenterCallback) {
        this.mEpicenterCallback = epicenterCallback;
    }

    @Nullable
    public EpicenterCallback getEpicenterCallback() {
        return this.mEpicenterCallback;
    }

    @Nullable
    public Rect getEpicenter() {
        if (this.mEpicenterCallback == null) {
            return null;
        }
        return this.mEpicenterCallback.onGetEpicenter(this);
    }

    public void setPropagation(@Nullable TransitionPropagation transitionPropagation) {
        this.mPropagation = transitionPropagation;
    }

    @Nullable
    public TransitionPropagation getPropagation() {
        return this.mPropagation;
    }

    void capturePropagationValues(TransitionValues transitionValues) {
        if (this.mPropagation != null && !transitionValues.values.isEmpty()) {
            String[] propertyNames = this.mPropagation.getPropagationProperties();
            if (propertyNames == null) {
                return;
            }
            boolean containsAll = true;
            for (int i = 0; i < propertyNames.length; ++i) {
                if (transitionValues.values.containsKey(propertyNames[i])) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) {
                this.mPropagation.captureValues(transitionValues);
            }
        }
    }

    Transition setSceneRoot(ViewGroup sceneRoot) {
        this.mSceneRoot = sceneRoot;
        return this;
    }

    void setCanRemoveViews(boolean canRemoveViews) {
        this.mCanRemoveViews = canRemoveViews;
    }

    public String toString() {
        return this.toString("");
    }

    public Transition clone() {
        try {
            Transition clone = (Transition)super.clone();
            clone.mAnimators = new ArrayList();
            clone.mStartValues = new TransitionValuesMaps();
            clone.mEndValues = new TransitionValuesMaps();
            clone.mStartValuesList = null;
            clone.mEndValuesList = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    String toString(String indent) {
        String result = indent + this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": ";
        if (this.mDuration != -1L) {
            result = result + "dur(" + this.mDuration + ") ";
        }
        if (this.mStartDelay != -1L) {
            result = result + "dly(" + this.mStartDelay + ") ";
        }
        if (this.mInterpolator != null) {
            result = result + "interp(" + this.mInterpolator + ") ";
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            int i;
            result = result + "tgts(";
            if (this.mTargetIds.size() > 0) {
                for (i = 0; i < this.mTargetIds.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.mTargetIds.get(i);
                }
            }
            if (this.mTargets.size() > 0) {
                for (i = 0; i < this.mTargets.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.mTargets.get(i);
                }
            }
            result = result + ")";
        }
        return result;
    }

    public static abstract class EpicenterCallback {
        public abstract Rect onGetEpicenter(@NonNull Transition var1);
    }

    private static class ArrayListManager {
        private ArrayListManager() {
        }

        static <T> ArrayList<T> add(ArrayList<T> list, T item) {
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(item)) {
                list.add(item);
            }
            return list;
        }

        static <T> ArrayList<T> remove(ArrayList<T> list, T item) {
            if (list != null) {
                list.remove(item);
                if (list.isEmpty()) {
                    list = null;
                }
            }
            return list;
        }
    }

    private static class AnimationInfo {
        View mView;
        String mName;
        TransitionValues mValues;
        WindowIdImpl mWindowId;
        Transition mTransition;

        AnimationInfo(View view, String name, Transition transition, WindowIdImpl windowId, TransitionValues values) {
            this.mView = view;
            this.mName = name;
            this.mValues = values;
            this.mWindowId = windowId;
            this.mTransition = transition;
        }
    }

    public static interface TransitionListener {
        public void onTransitionStart(@NonNull Transition var1);

        public void onTransitionEnd(@NonNull Transition var1);

        public void onTransitionCancel(@NonNull Transition var1);

        public void onTransitionPause(@NonNull Transition var1);

        public void onTransitionResume(@NonNull Transition var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface MatchOrder {
    }
}

