#define motorPin 13

int received; //for the received Byte
int fanSpeed = 127; //initial speed - must be a number between 0 and 255


void setup() {
  Serial.begin(9600); //for communication with the app
  delay(3000); // small delay
  
  pinMode(motorPin, OUTPUT); //define motor pin as output
  analogWrite(motorPin,fanSpeed); //set the initial speed of the fan
}

void loop() {
  
  while(Serial.available()) 
  {
     received = Serial.read(); //received Byte
    
     Serial.println(received); //if the arduino is connected to the PC, than you can check the received Byte

     switch (received)  //you can easily add new cases to customize your arduino
     {
        case 200:
            Serial.println("RESTARTED");
            break;
        default:
            if(received >0 && received <=127)
            {
              fanSpeed = (received*2); //app sends value between 0 and 127 - so we need to double it for the fan range between 0 and 255
              delay(10);
            }
            break;
     }  
  }
  analogWrite(motorPin,fanSpeed); //set the speed of the fan
}
