/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.RestrictTo;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ButtonBarLayout
extends LinearLayout {
    private static final int PEEK_BUTTON_DP = 16;
    private boolean mAllowStacking;
    private int mLastWidthSize = -1;
    private int mMinimumHeight = 0;

    public ButtonBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ButtonBarLayout);
        this.mAllowStacking = ta.getBoolean(R.styleable.ButtonBarLayout_allowStacking, true);
        ta.recycle();
    }

    public void setAllowStacking(boolean allowStacking) {
        if (this.mAllowStacking != allowStacking) {
            this.mAllowStacking = allowStacking;
            if (!this.mAllowStacking && this.getOrientation() == 1) {
                this.setStacked(false);
            }
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int initialWidthMeasureSpec;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.mAllowStacking) {
            if (widthSize > this.mLastWidthSize && this.isStacked()) {
                this.setStacked(false);
            }
            this.mLastWidthSize = widthSize;
        }
        boolean needsRemeasure = false;
        if (!this.isStacked() && View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000) {
            initialWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)Integer.MIN_VALUE);
            needsRemeasure = true;
        } else {
            initialWidthMeasureSpec = widthMeasureSpec;
        }
        super.onMeasure(initialWidthMeasureSpec, heightMeasureSpec);
        if (this.mAllowStacking && !this.isStacked()) {
            boolean stack;
            int measuredWidth = this.getMeasuredWidthAndState();
            int measuredWidthState = measuredWidth & 0xFF000000;
            boolean bl = stack = measuredWidthState == 0x1000000;
            if (stack) {
                this.setStacked(true);
                needsRemeasure = true;
            }
        }
        if (needsRemeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        int minHeight = 0;
        int firstVisible = this.getNextVisibleChildIndex(0);
        if (firstVisible >= 0) {
            View firstButton = this.getChildAt(firstVisible);
            LinearLayout.LayoutParams firstParams = (LinearLayout.LayoutParams)firstButton.getLayoutParams();
            minHeight += this.getPaddingTop() + firstButton.getMeasuredHeight() + firstParams.topMargin + firstParams.bottomMargin;
            if (this.isStacked()) {
                int secondVisible = this.getNextVisibleChildIndex(firstVisible + 1);
                if (secondVisible >= 0) {
                    minHeight += this.getChildAt(secondVisible).getPaddingTop() + (int)(16.0f * this.getResources().getDisplayMetrics().density);
                }
            } else {
                minHeight += this.getPaddingBottom();
            }
        }
        if (ViewCompat.getMinimumHeight((View)this) != minHeight) {
            this.setMinimumHeight(minHeight);
        }
    }

    private int getNextVisibleChildIndex(int index) {
        int count = this.getChildCount();
        for (int i = index; i < count; ++i) {
            if (this.getChildAt(i).getVisibility() != 0) continue;
            return i;
        }
        return -1;
    }

    public int getMinimumHeight() {
        return Math.max(this.mMinimumHeight, super.getMinimumHeight());
    }

    private void setStacked(boolean stacked) {
        this.setOrientation(stacked ? 1 : 0);
        this.setGravity(stacked ? 5 : 80);
        View spacer = this.findViewById(R.id.spacer);
        if (spacer != null) {
            spacer.setVisibility(stacked ? 8 : 4);
        }
        int childCount = this.getChildCount();
        for (int i = childCount - 2; i >= 0; --i) {
            this.bringChildToFront(this.getChildAt(i));
        }
    }

    private boolean isStacked() {
        return this.getOrientation() == 1;
    }
}

