﻿using HtmlAgilityPack;
using System;
using System.Linq;
using System.Net.Http;

namespace DemoScraper
{
    class Program
    {
        static async System.Threading.Tasks.Task Main(string[] args)
        {
            //choose your website
            var url = "https://nerd-corner.com/2020/03/12/android-bluetooth-classic-app-for-arduino-fan-control/";

            //get the html page source 
            var httpClient = new HttpClient();
            var html = await httpClient.GetStringAsync(url);

            //store the html of the page in a variable
            var doc = new HtmlDocument();
            doc.LoadHtml(html);



            //to display the headers
            var pageHtml = doc.DocumentNode.Descendants("h1").FirstOrDefault().InnerText;

            Console.WriteLine("Title of the post: " + pageHtml );

            //to display the subheaders //Need a list, because there a multiple subheaders
            var subheaders= doc.DocumentNode.Descendants("h2").ToList();
            Console.WriteLine("Subheaders:");
            //to display each element in the list
            foreach (var element in subheaders)
            {
                Console.WriteLine(element.InnerText);
            }


            //This writes 10 "ul" elements in the list. Our list of components is number 8 in the list
            var components = doc.DocumentNode.Descendants("ul").ToList();
            Console.WriteLine("Component list items: " + components[8].InnerText);


            //The Download Files are links and the class is called download-links, 
            //so we search for <a></a> with this attributes
            var downloadFiles = doc.DocumentNode.Descendants("a")
                .Where(node=>node.GetAttributeValue("class","").Equals("download-link")).ToList();

            Console.WriteLine("Name of the downloadlink + link:");

            //to display each listelement
            foreach(var element in downloadFiles)
            {
                //the name of the file
                Console.WriteLine(element.InnerText.Trim('\n','\t'));

                //the downloadlink of the file
                Console.WriteLine(element.GetAttributeValue("href","").Trim('\n', '\t'));
            }
        }

        
    }
}
