/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v7.app.MediaRouterThemeHelper;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatSeekBar;
import android.util.AttributeSet;
import android.util.Log;

class MediaRouteVolumeSlider
extends AppCompatSeekBar {
    private static final String TAG = "MediaRouteVolumeSlider";
    private final float mDisabledAlpha;
    private boolean mHideThumb;
    private Drawable mThumb;
    private int mColor;

    public MediaRouteVolumeSlider(Context context) {
        this(context, null);
    }

    public MediaRouteVolumeSlider(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.seekBarStyle);
    }

    public MediaRouteVolumeSlider(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDisabledAlpha = MediaRouterThemeHelper.getDisabledAlpha(context);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int alpha = this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha);
        this.mThumb.setColorFilter(this.mColor, PorterDuff.Mode.SRC_IN);
        this.mThumb.setAlpha(alpha);
        this.getProgressDrawable().setColorFilter(this.mColor, PorterDuff.Mode.SRC_IN);
        this.getProgressDrawable().setAlpha(alpha);
    }

    public void setThumb(Drawable thumb) {
        this.mThumb = thumb;
        super.setThumb(this.mHideThumb ? null : this.mThumb);
    }

    public void setHideThumb(boolean hideThumb) {
        if (this.mHideThumb == hideThumb) {
            return;
        }
        this.mHideThumb = hideThumb;
        super.setThumb(this.mHideThumb ? null : this.mThumb);
    }

    public void setColor(int color2) {
        if (this.mColor == color2) {
            return;
        }
        if (Color.alpha((int)color2) != 255) {
            Log.e((String)TAG, (String)("Volume slider color cannot be translucent: #" + Integer.toHexString(color2)));
        }
        this.mColor = color2;
    }
}

