/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
extends zzbck
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zzb();
    private static zzd zzebv = zzh.zzalc();
    private int versionCode;
    private String zzbsx;
    private String zzeaw;
    private String zzebw;
    private String zzebx;
    private Uri zzeby;
    private String zzebz;
    private long zzeca;
    private String zzecb;
    private List<Scope> zzdxx;
    private String zzeaf;
    private String zzeag;
    private static Comparator<Scope> zzecc = new zza();

    @Nullable
    public static GoogleSignInAccount zzem(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        HashSet<Scope> hashSet2 = hashSet;
        String string4 = jSONObject.getString("obfuscatedIdentifier");
        Long l2 = l;
        Uri uri2 = uri;
        String string5 = jSONObject.optString("familyName", null);
        String string6 = jSONObject.optString("givenName", null);
        String string7 = jSONObject.optString("displayName", null);
        String string8 = jSONObject.optString("email", null);
        String string9 = jSONObject.optString("tokenId", null);
        Object object = jSONObject.optString("id");
        if (l2 == null) {
            l2 = zzebv.currentTimeMillis() / 1000L;
        }
        GoogleSignInAccount googleSignInAccount = new GoogleSignInAccount(3, (String)object, string9, string8, string7, uri2, null, l2, zzbp.zzgg((String)string4), (List<Scope>)new ArrayList<Scope>((Collection)zzbp.zzu(hashSet2)), string6, string5);
        string9 = jSONObject.optString("serverAuthCode", null);
        object = googleSignInAccount;
        googleSignInAccount.zzebz = string9;
        return object;
    }

    GoogleSignInAccount(int n, String string2, String string3, String string4, String string5, Uri uri, String string6, long l, String string7, List<Scope> list, String string8, String string9) {
        this.versionCode = n;
        this.zzbsx = string2;
        this.zzeaw = string3;
        this.zzebw = string4;
        this.zzebx = string5;
        this.zzeby = uri;
        this.zzebz = string6;
        this.zzeca = l;
        this.zzecb = string7;
        this.zzdxx = list;
        this.zzeaf = string8;
        this.zzeag = string9;
    }

    @Nullable
    public String getId() {
        return this.zzbsx;
    }

    @Nullable
    public String getIdToken() {
        return this.zzeaw;
    }

    @Nullable
    public String getEmail() {
        return this.zzebw;
    }

    @Nullable
    public Account getAccount() {
        if (this.zzebw == null) {
            return null;
        }
        return new Account(this.zzebw, "com.google");
    }

    @Nullable
    public String getDisplayName() {
        return this.zzebx;
    }

    @Nullable
    public String getGivenName() {
        return this.zzeaf;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzeag;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zzeby;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zzebz;
    }

    public final boolean zzaad() {
        return zzebv.currentTimeMillis() / 1000L >= this.zzeca - 300L;
    }

    @NonNull
    public final String zzaae() {
        return this.zzecb;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzdxx);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInAccount googleSignInAccount = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)googleSignInAccount.versionCode);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)googleSignInAccount.getId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (String)googleSignInAccount.getIdToken(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)googleSignInAccount.getEmail(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (String)googleSignInAccount.getDisplayName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (Parcelable)googleSignInAccount.getPhotoUrl(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (String)googleSignInAccount.getServerAuthCode(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (long)googleSignInAccount.zzeca);
        zzbcn.zza((Parcel)parcel2, (int)9, (String)googleSignInAccount.zzecb, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)10, googleSignInAccount.zzdxx, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)11, (String)googleSignInAccount.getGivenName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)12, (String)googleSignInAccount.getFamilyName(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return this.toJsonObject().toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        return ((GoogleSignInAccount)((Object)object)).toJsonObject().toString().equals(this.toJsonObject().toString());
    }

    public final String zzaaf() {
        JSONObject jSONObject = this.toJsonObject();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzeca);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzecb);
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzdxx, zzecc);
            for (Scope scope : this.zzdxx) {
                jSONArray.put((Object)scope.zzaft());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

