/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzab;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzy
implements zzcd {
    private final Context mContext;
    private final zzbd zzfju;
    private final Looper zzakg;
    private final zzbl zzfjv;
    private final zzbl zzfjw;
    private final Map<Api.zzc<?>, zzbl> zzfjx;
    private final Set<zzcv> zzfjy = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzfjz;
    private Bundle zzfka;
    private ConnectionResult zzfkb = null;
    private ConnectionResult zzfkc = null;
    private boolean zzfkd = false;
    private final Lock zzfke;
    private int zzfkf = 0;

    public static zzy zza(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcps, zzcpt> zza2, ArrayList<zzw> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzaal()) {
                zze3 = object;
            }
            if (object.zzaac()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbp.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzafe();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzw>();
        ArrayList<zzw> arrayList2 = new ArrayList<zzw>();
        ArrayList<zzw> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList3.get(i);
            zzw zzw3 = zzw2;
            if (arrayMap5.containsKey(zzw3.zzfdg)) {
                ((ArrayList)object).add(zzw3);
                continue;
            }
            if (arrayMap.containsKey(zzw3.zzfdg)) {
                arrayList2.add(zzw3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzy(context, zzbd2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzq2, zza2, zze3, (ArrayList<zzw>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzy(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzq zzq2, Api.zza<? extends zzcps, zzcpt> zza2, Api.zze zze3, ArrayList<zzw> arrayList, ArrayList<zzw> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzfju = zzbd2;
        this.zzfke = lock;
        this.zzakg = looper;
        this.zzfjz = zze3;
        this.zzfjv = new zzbl(context, this.zzfju, lock, looper, zze2, map2, null, map4, null, arrayList2, new zzaa(this, null));
        this.zzfjw = new zzbl(context, this.zzfju, lock, looper, zze2, map, zzq2, map3, zza2, arrayList, new zzab(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfjv);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfjw);
        }
        this.zzfjx = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzagl()) {
                t.zzt(new Status(4, null, this.zzagm()));
                return t;
            }
            return this.zzfjw.zzd(t);
        }
        return this.zzfjv.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzagl()) {
                t.zzt(new Status(4, null, this.zzagm()));
                return t;
            }
            return this.zzfjw.zze(t);
        }
        return this.zzfjv.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzfjx.get(api.zzafe()).equals(this.zzfjw)) {
            if (this.zzagl()) {
                return new ConnectionResult(4, this.zzagm());
            }
            return this.zzfjw.getConnectionResult(api);
        }
        return this.zzfjv.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzfkf = 2;
        this.zzfkd = false;
        zzy zzy2 = this;
        this.zzfkc = null;
        zzy2.zzfkb = null;
        zzy2.zzfjv.connect();
        zzy2.zzfjw.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzfkc = null;
        this.zzfkb = null;
        this.zzfkf = 0;
        this.zzfjv.disconnect();
        this.zzfjw.disconnect();
        this.zzagk();
    }

    @Override
    public final boolean isConnected() {
        this.zzfke.lock();
        try {
            boolean bl = this.zzfjv.isConnected() && (this.zzfjw.isConnected() || this.zzagl() || this.zzfkf == 1);
            return bl;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfke.lock();
        try {
            boolean bl = this.zzfkf == 2;
            return bl;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        this.zzfke.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzfjw.isConnected()) {
                this.zzfjy.add(zzcv2);
                if (this.zzfkf == 0) {
                    this.zzfkf = 1;
                }
                this.zzfkc = null;
                this.zzfjw.connect();
                return true;
            }
        }
        finally {
            this.zzfke.unlock();
        }
        return false;
    }

    @Override
    public final void zzagi() {
        this.zzfjv.zzagi();
        this.zzfjw.zzagi();
    }

    @Override
    public final void zzafp() {
        this.zzfke.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzfjw.disconnect();
            this.zzfkc = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzakg).post((Runnable)new zzz(this));
            } else {
                this.zzagk();
            }
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    private final void zzagj() {
        if (zzy.zzb(this.zzfkb)) {
            if (zzy.zzb(this.zzfkc) || this.zzagl()) {
                zzy zzy2 = this;
                switch (zzy2.zzfkf) {
                    case 2: {
                        zzy2.zzfju.zzj(zzy2.zzfka);
                    }
                    case 1: {
                        zzy2.zzagk();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzy2.zzfkf = 0;
                return;
            }
            if (this.zzfkc != null) {
                if (this.zzfkf == 1) {
                    this.zzagk();
                    return;
                }
                this.zza(this.zzfkc);
                this.zzfjv.disconnect();
                return;
            }
        } else {
            if (this.zzfkb != null && zzy.zzb(this.zzfkc)) {
                this.zzfjw.disconnect();
                this.zza(this.zzfkb);
                return;
            }
            if (this.zzfkb != null && this.zzfkc != null) {
                ConnectionResult connectionResult = this.zzfkb;
                if (this.zzfjw.zzfnf < this.zzfjv.zzfnf) {
                    connectionResult = this.zzfkc;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzfkf) {
            case 2: {
                this.zzfju.zzc(connectionResult);
            }
            case 1: {
                this.zzagk();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzfkf = 0;
    }

    private final void zzagk() {
        Iterator<zzcv> iterator = this.zzfjy.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzaak();
        }
        this.zzfjy.clear();
    }

    private final void zze(int n, boolean bl) {
        this.zzfju.zzf(n, bl);
        this.zzfkc = null;
        this.zzfkb = null;
    }

    private final boolean zzagl() {
        return this.zzfkc != null && this.zzfkc.getErrorCode() == 4;
    }

    private final boolean zzf(zzm<? extends Result, ? extends Api.zzb> zzm2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzm2.zzafe();
        zzbp.zzb((boolean)this.zzfjx.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzfjx.get(zzc2).equals(this.zzfjw);
    }

    @Nullable
    private final PendingIntent zzagm() {
        if (this.zzfjz == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzfju), (Intent)this.zzfjz.zzaam(), (int)0x8000000);
    }

    private final void zzi(Bundle bundle) {
        if (this.zzfka == null) {
            this.zzfka = bundle;
            return;
        }
        if (bundle != null) {
            this.zzfka.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzfjw.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzfjv.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzy zzy2) {
        return zzy2.zzfke;
    }

    static /* synthetic */ void zzb(zzy zzy2) {
        zzy2.zzagj();
    }

    static /* synthetic */ void zza(zzy zzy2, Bundle bundle) {
        zzy2.zzi(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfkb = connectionResult;
        return zzy2.zzfkb;
    }

    static /* synthetic */ boolean zzc(zzy zzy2) {
        return zzy2.zzfkd;
    }

    static /* synthetic */ ConnectionResult zzd(zzy zzy2) {
        return zzy2.zzfkc;
    }

    static /* synthetic */ boolean zza(zzy zzy2, boolean bl) {
        zzy2.zzfkd = bl;
        return zzy2.zzfkd;
    }

    static /* synthetic */ void zza(zzy zzy2, int n, boolean bl) {
        zzy2.zze(n, bl);
    }

    static /* synthetic */ zzbl zze(zzy zzy2) {
        return zzy2.zzfjw;
    }

    static /* synthetic */ ConnectionResult zzb(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfkc = connectionResult;
        return zzy2.zzfkc;
    }

    static /* synthetic */ zzbl zzf(zzy zzy2) {
        return zzy2.zzfjv;
    }
}

