﻿using DemoGoogleMapApp.Droid;
using Xamarin.Forms.GoogleMaps;
using Xamarin.Forms.GoogleMaps.Android.Factories;
using AndroidBitmapDescriptor = Android.Gms.Maps.Model.BitmapDescriptor;
using AndroidBitmapDescriptorFactory = Android.Gms.Maps.Model.BitmapDescriptorFactory;

public sealed class BitmapConfig : IBitmapDescriptorFactory
{
    public AndroidBitmapDescriptor ToNative(BitmapDescriptor descriptor)
    {
        int iconId = 0;
        switch (descriptor.Id)
        {
            case "castle":
                iconId = Resource.Drawable.castle;
                break;
            case "beer":
                iconId = Resource.Drawable.beer;
                break;
        }

        return AndroidBitmapDescriptorFactory.FromResource(iconId);
    }
}