/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class zzai
implements ServiceConnection {
    private final Set<ServiceConnection> zzfvc;
    private int mState;
    private boolean zzfvd;
    private IBinder zzftq;
    private final zzag zzfve;
    private ComponentName zzfuw;
    private /* synthetic */ zzah zzfvf;

    public zzai(zzah zzah2, zzag zzag2) {
        this.zzfvf = zzah2;
        this.zzfve = zzag2;
        this.zzfvc = new HashSet<ServiceConnection>();
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zzah.zza(this.zzfvf);
        synchronized (hashMap) {
            zzah.zzb(this.zzfvf).removeMessages(1, (Object)this.zzfve);
            this.zzftq = iBinder;
            this.zzfuw = componentName;
            Iterator<ServiceConnection> iterator = this.zzfvc.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            this.mState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zzah.zza(this.zzfvf);
        synchronized (hashMap) {
            zzah.zzb(this.zzfvf).removeMessages(1, (Object)this.zzfve);
            this.zzftq = null;
            this.zzfuw = componentName;
            Iterator<ServiceConnection> iterator = this.zzfvc.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceDisconnected(componentName);
            }
            this.mState = 2;
            return;
        }
    }

    public final void zzgc(String string2) {
        this.mState = 3;
        this.zzfvd = zzah.zzd(this.zzfvf).zza(zzah.zzc(this.zzfvf), string2, this.zzfve.zzakh(), this, this.zzfve.zzakg());
        if (this.zzfvd) {
            Message message = zzah.zzb(this.zzfvf).obtainMessage(1, (Object)this.zzfve);
            zzah.zzb(this.zzfvf).sendMessageDelayed(message, zzah.zze(this.zzfvf));
            return;
        }
        this.mState = 2;
        try {
            zzah.zzd(this.zzfvf);
            zzai zzai2 = this;
            Context context = zzah.zzc(this.zzfvf);
            context.unbindService((ServiceConnection)zzai2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final void zzgd(String string2) {
        zzah.zzb(this.zzfvf).removeMessages(1, (Object)this.zzfve);
        zzah.zzd(this.zzfvf);
        zzai zzai2 = this;
        Context context = zzah.zzc(this.zzfvf);
        context.unbindService((ServiceConnection)zzai2);
        this.zzfvd = false;
        this.mState = 2;
    }

    public final void zza(ServiceConnection serviceConnection, String string2) {
        zzah.zzd(this.zzfvf);
        zzah.zzc(this.zzfvf);
        this.zzfve.zzakh();
        this.zzfvc.add(serviceConnection);
    }

    public final void zzb(ServiceConnection serviceConnection, String string2) {
        zzah.zzd(this.zzfvf);
        zzah.zzc(this.zzfvf);
        this.zzfvc.remove(serviceConnection);
    }

    public final boolean isBound() {
        return this.zzfvd;
    }

    public final int getState() {
        return this.mState;
    }

    public final boolean zza(ServiceConnection serviceConnection) {
        return this.zzfvc.contains(serviceConnection);
    }

    public final boolean zzaki() {
        return this.zzfvc.isEmpty();
    }

    public final IBinder getBinder() {
        return this.zzftq;
    }

    public final ComponentName getComponentName() {
        return this.zzfuw;
    }
}

