/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.zzc;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zzbck
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzecd = new Scope("profile");
    public static final Scope zzece = new Scope("email");
    public static final Scope zzecf = new Scope("openid");
    private static Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzd();
    private int versionCode;
    private final ArrayList<Scope> zzecg;
    private Account zzduz;
    private boolean zzeap;
    private final boolean zzech;
    private final boolean zzeci;
    private String zzeaq;
    private String zzecj;
    private ArrayList<zzn> zzeck;
    private Map<Integer, zzn> zzecl;
    private static Comparator<Scope> zzecc = new zzc();

    @Nullable
    public static GoogleSignInOptions zzen(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzn>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzn> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzu(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzn> map) {
        this.versionCode = n;
        this.zzecg = arrayList;
        this.zzduz = account;
        this.zzeap = bl;
        this.zzech = bl2;
        this.zzeci = bl3;
        this.zzeaq = string2;
        this.zzecj = string3;
        this.zzeck = new ArrayList<zzn>(map.values());
        this.zzecl = map;
    }

    public final ArrayList<Scope> zzaag() {
        return new ArrayList<Scope>(this.zzecg);
    }

    public Scope[] getScopeArray() {
        return this.zzecg.toArray(new Scope[this.zzecg.size()]);
    }

    public final Account getAccount() {
        return this.zzduz;
    }

    public final boolean isIdTokenRequested() {
        return this.zzeap;
    }

    public final boolean zzaah() {
        return this.zzech;
    }

    public final String getServerClientId() {
        return this.zzeaq;
    }

    private static Map<Integer, zzn> zzu(@Nullable List<zzn> list) {
        HashMap<Integer, zzn> hashMap = new HashMap<Integer, zzn>();
        if (list == null) {
            return hashMap;
        }
        for (zzn zzn2 : list) {
            hashMap.put(zzn2.getType(), zzn2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        zzbcn.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzaag(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzduz, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzeap);
        zzbcn.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzech);
        zzbcn.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzeci);
        zzbcn.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzeaq, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzecj, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzeck, (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzeck.size() > 0 || googleSignInOptions.zzeck.size() > 0) {
                return false;
            }
            if (this.zzecg.size() != googleSignInOptions.zzaag().size() || !this.zzecg.containsAll(googleSignInOptions.zzaag())) {
                return false;
            }
            return (this.zzduz == null ? googleSignInOptions.zzduz == null : this.zzduz.equals((Object)googleSignInOptions.zzduz)) && (TextUtils.isEmpty((CharSequence)this.zzeaq) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzeaq) : this.zzeaq.equals(googleSignInOptions.zzeaq)) && this.zzeci == googleSignInOptions.zzeci && this.zzeap == googleSignInOptions.zzeap && this.zzech == googleSignInOptions.zzech;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzecg;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzaft());
        }
        Collections.sort(arrayList);
        return new zzo().zzo(arrayList).zzo(this.zzduz).zzo(this.zzeaq).zzaq(this.zzeci).zzaq(this.zzeap).zzaq(this.zzech).zzaao();
    }

    public final String zzaai() {
        return this.toJsonObject().toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzecg, zzecc);
            ArrayList<Scope> arrayList = this.zzecg;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzaft());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzduz != null) {
                jSONObject.put("accountName", (Object)this.zzduz.name);
            }
            jSONObject.put("idTokenRequested", this.zzeap);
            jSONObject.put("forceCodeForRefreshToken", this.zzeci);
            jSONObject.put("serverAuthRequested", this.zzech);
            if (!TextUtils.isEmpty((CharSequence)this.zzeaq)) {
                jSONObject.put("serverClientId", (Object)this.zzeaq);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzecj)) {
                jSONObject.put("hostedDomain", (Object)this.zzecj);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzc zzc2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzecm = new HashSet<Scope>();
        private boolean zzech;
        private boolean zzeci;
        private boolean zzeap;
        private String zzeaq;
        private Account zzduz;
        private String zzecj;
        private Map<Integer, zzn> zzecn = new HashMap<Integer, zzn>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbp.zzu((Object)googleSignInOptions);
            this.zzecm = new HashSet<Scope>(googleSignInOptions.zzecg);
            this.zzech = googleSignInOptions.zzech;
            this.zzeci = googleSignInOptions.zzeci;
            this.zzeap = googleSignInOptions.zzeap;
            this.zzeaq = googleSignInOptions.zzeaq;
            this.zzduz = googleSignInOptions.zzduz;
            this.zzecj = googleSignInOptions.zzecj;
            this.zzecn = GoogleSignInOptions.zzu(googleSignInOptions.zzeck);
        }

        public final Builder requestId() {
            this.zzecm.add(zzecf);
            return this;
        }

        public final Builder requestEmail() {
            this.zzecm.add(zzece);
            return this;
        }

        public final Builder requestProfile() {
            this.zzecm.add(zzecd);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzecm.add(scope);
            this.zzecm.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzeap = true;
            this.zzeaq = this.zzeo(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzech = true;
            this.zzeaq = this.zzeo(string2);
            this.zzeci = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzduz = new Account(zzbp.zzgg((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzecj = zzbp.zzgg((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzecn.containsKey(1)) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            this.zzecn.put(1, new zzn(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzeap && (this.zzduz == null || !this.zzecm.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzecm), this.zzduz, this.zzeap, this.zzech, this.zzeci, this.zzeaq, this.zzecj, this.zzecn, null);
        }

        private final String zzeo(String string2) {
            zzbp.zzgg((String)string2);
            zzbp.zzb((this.zzeaq == null || this.zzeaq.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

