/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.os;

import android.os.Build;
import android.support.annotation.GuardedBy;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.Size;
import android.support.v4.os.LocaleHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class LocaleListHelper {
    private final Locale[] mList;
    @NonNull
    private final String mStringRepresentation;
    private static final Locale[] sEmptyList = new Locale[0];
    private static final LocaleListHelper sEmptyLocaleList = new LocaleListHelper(new Locale[0]);
    private static final String STRING_EN_XA = "en-XA";
    private static final String STRING_AR_XB = "ar-XB";
    private static final Locale LOCALE_EN_XA = new Locale("en", "XA");
    private static final Locale LOCALE_AR_XB = new Locale("ar", "XB");
    private static final int NUM_PSEUDO_LOCALES = 2;
    private static final Locale EN_LATN = LocaleHelper.forLanguageTag("en-Latn");
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static LocaleListHelper sLastExplicitlySetLocaleList = null;
    @GuardedBy(value="sLock")
    private static LocaleListHelper sDefaultLocaleList = null;
    @GuardedBy(value="sLock")
    private static LocaleListHelper sDefaultAdjustedLocaleList = null;
    @GuardedBy(value="sLock")
    private static Locale sLastDefaultLocale = null;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    Locale get(int index) {
        return 0 <= index && index < this.mList.length ? this.mList[index] : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    boolean isEmpty() {
        return this.mList.length == 0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=0L)
    int size() {
        return this.mList.length;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=-1L)
    int indexOf(Locale locale) {
        for (int i = 0; i < this.mList.length; ++i) {
            if (!this.mList[i].equals(locale)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LocaleListHelper)) {
            return false;
        }
        Locale[] otherList = ((LocaleListHelper)other).mList;
        if (this.mList.length != otherList.length) {
            return false;
        }
        for (int i = 0; i < this.mList.length; ++i) {
            if (this.mList[i].equals(otherList[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.mList.length; ++i) {
            result = 31 * result + this.mList[i].hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.mList.length; ++i) {
            sb.append(this.mList[i]);
            if (i >= this.mList.length - 1) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    String toLanguageTags() {
        return this.mStringRepresentation;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    LocaleListHelper(Locale ... list) {
        if (list.length == 0) {
            this.mList = sEmptyList;
            this.mStringRepresentation = "";
        } else {
            Locale[] localeList = new Locale[list.length];
            HashSet<Locale> seenLocales = new HashSet<Locale>();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                Locale localeClone;
                Locale l = list[i];
                if (l == null) {
                    throw new NullPointerException("list[" + i + "] is null");
                }
                if (seenLocales.contains(l)) {
                    throw new IllegalArgumentException("list[" + i + "] is a repetition");
                }
                localeList[i] = localeClone = (Locale)l.clone();
                sb.append(LocaleHelper.toLanguageTag(localeClone));
                if (i < list.length - 1) {
                    sb.append(',');
                }
                seenLocales.add(localeClone);
            }
            this.mList = localeList;
            this.mStringRepresentation = sb.toString();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    LocaleListHelper(@NonNull Locale topLocale, LocaleListHelper otherLocales) {
        int i;
        if (topLocale == null) {
            throw new NullPointerException("topLocale is null");
        }
        int inputLength = otherLocales == null ? 0 : otherLocales.mList.length;
        int topLocaleIndex = -1;
        for (int i2 = 0; i2 < inputLength; ++i2) {
            if (!topLocale.equals(otherLocales.mList[i2])) continue;
            topLocaleIndex = i2;
            break;
        }
        int outputLength = inputLength + (topLocaleIndex == -1 ? 1 : 0);
        Locale[] localeList = new Locale[outputLength];
        localeList[0] = (Locale)topLocale.clone();
        if (topLocaleIndex == -1) {
            for (i = 0; i < inputLength; ++i) {
                localeList[i + 1] = (Locale)otherLocales.mList[i].clone();
            }
        } else {
            for (i = 0; i < topLocaleIndex; ++i) {
                localeList[i + 1] = (Locale)otherLocales.mList[i].clone();
            }
            for (i = topLocaleIndex + 1; i < inputLength; ++i) {
                localeList[i] = (Locale)otherLocales.mList[i].clone();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i3 = 0; i3 < outputLength; ++i3) {
            sb.append(LocaleHelper.toLanguageTag(localeList[i3]));
            if (i3 >= outputLength - 1) continue;
            sb.append(',');
        }
        this.mList = localeList;
        this.mStringRepresentation = sb.toString();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    static LocaleListHelper getEmptyLocaleList() {
        return sEmptyLocaleList;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    static LocaleListHelper forLanguageTags(@Nullable String list) {
        if (list == null || list.isEmpty()) {
            return LocaleListHelper.getEmptyLocaleList();
        }
        String[] tags = list.split(",", -1);
        Locale[] localeArray = new Locale[tags.length];
        for (int i = 0; i < localeArray.length; ++i) {
            localeArray[i] = LocaleHelper.forLanguageTag(tags[i]);
        }
        return new LocaleListHelper(localeArray);
    }

    private static String getLikelyScript(Locale locale) {
        if (Build.VERSION.SDK_INT >= 21) {
            String script = locale.getScript();
            if (!script.isEmpty()) {
                return script;
            }
            return "";
        }
        return "";
    }

    private static boolean isPseudoLocale(String locale) {
        return STRING_EN_XA.equals(locale) || STRING_AR_XB.equals(locale);
    }

    private static boolean isPseudoLocale(Locale locale) {
        return LOCALE_EN_XA.equals(locale) || LOCALE_AR_XB.equals(locale);
    }

    @IntRange(from=0L, to=1L)
    private static int matchScore(Locale supported, Locale desired) {
        if (supported.equals(desired)) {
            return 1;
        }
        if (!supported.getLanguage().equals(desired.getLanguage())) {
            return 0;
        }
        if (LocaleListHelper.isPseudoLocale(supported) || LocaleListHelper.isPseudoLocale(desired)) {
            return 0;
        }
        String supportedScr = LocaleListHelper.getLikelyScript(supported);
        if (supportedScr.isEmpty()) {
            String supportedRegion = supported.getCountry();
            return supportedRegion.isEmpty() || supportedRegion.equals(desired.getCountry()) ? 1 : 0;
        }
        String desiredScr = LocaleListHelper.getLikelyScript(desired);
        return supportedScr.equals(desiredScr) ? 1 : 0;
    }

    private int findFirstMatchIndex(Locale supportedLocale) {
        for (int idx = 0; idx < this.mList.length; ++idx) {
            int score = LocaleListHelper.matchScore(supportedLocale, this.mList[idx]);
            if (score <= 0) continue;
            return idx;
        }
        return Integer.MAX_VALUE;
    }

    private int computeFirstMatchIndex(Collection<String> supportedLocales, boolean assumeEnglishIsSupported) {
        if (this.mList.length == 1) {
            return 0;
        }
        if (this.mList.length == 0) {
            return -1;
        }
        int bestIndex = Integer.MAX_VALUE;
        if (assumeEnglishIsSupported) {
            int idx = this.findFirstMatchIndex(EN_LATN);
            if (idx == 0) {
                return 0;
            }
            if (idx < bestIndex) {
                bestIndex = idx;
            }
        }
        for (String languageTag : supportedLocales) {
            Locale supportedLocale = LocaleHelper.forLanguageTag(languageTag);
            int idx = this.findFirstMatchIndex(supportedLocale);
            if (idx == 0) {
                return 0;
            }
            if (idx >= bestIndex) continue;
            bestIndex = idx;
        }
        if (bestIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return bestIndex;
    }

    private Locale computeFirstMatch(Collection<String> supportedLocales, boolean assumeEnglishIsSupported) {
        int bestIndex = this.computeFirstMatchIndex(supportedLocales, assumeEnglishIsSupported);
        return bestIndex == -1 ? null : this.mList[bestIndex];
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    Locale getFirstMatch(String[] supportedLocales) {
        return this.computeFirstMatch(Arrays.asList(supportedLocales), false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    int getFirstMatchIndex(String[] supportedLocales) {
        return this.computeFirstMatchIndex(Arrays.asList(supportedLocales), false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    Locale getFirstMatchWithEnglishSupported(String[] supportedLocales) {
        return this.computeFirstMatch(Arrays.asList(supportedLocales), true);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    int getFirstMatchIndexWithEnglishSupported(Collection<String> supportedLocales) {
        return this.computeFirstMatchIndex(supportedLocales, true);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    int getFirstMatchIndexWithEnglishSupported(String[] supportedLocales) {
        return this.getFirstMatchIndexWithEnglishSupported(Arrays.asList(supportedLocales));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static boolean isPseudoLocalesOnly(@Nullable String[] supportedLocales) {
        if (supportedLocales == null) {
            return true;
        }
        if (supportedLocales.length > 3) {
            return false;
        }
        for (String locale : supportedLocales) {
            if (locale.isEmpty() || LocaleListHelper.isPseudoLocale(locale)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    @Size(min=1L)
    static LocaleListHelper getDefault() {
        Locale defaultLocale = Locale.getDefault();
        Object object = sLock;
        synchronized (object) {
            if (!defaultLocale.equals(sLastDefaultLocale)) {
                sLastDefaultLocale = defaultLocale;
                if (sDefaultLocaleList != null && defaultLocale.equals(sDefaultLocaleList.get(0))) {
                    return sDefaultLocaleList;
                }
                sDefaultAdjustedLocaleList = sDefaultLocaleList = new LocaleListHelper(defaultLocale, sLastExplicitlySetLocaleList);
            }
            return sDefaultLocaleList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @Size(min=1L)
    static LocaleListHelper getAdjustedDefault() {
        LocaleListHelper.getDefault();
        Object object = sLock;
        synchronized (object) {
            return sDefaultAdjustedLocaleList;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static void setDefault(@NonNull @Size(min=1L) LocaleListHelper locales) {
        LocaleListHelper.setDefault(locales, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static void setDefault(@NonNull @Size(min=1L) LocaleListHelper locales, int localeIndex) {
        if (locales == null) {
            throw new NullPointerException("locales is null");
        }
        if (locales.isEmpty()) {
            throw new IllegalArgumentException("locales is empty");
        }
        Object object = sLock;
        synchronized (object) {
            sLastDefaultLocale = locales.get(localeIndex);
            Locale.setDefault(sLastDefaultLocale);
            sLastExplicitlySetLocaleList = locales;
            sDefaultLocaleList = locales;
            sDefaultAdjustedLocaleList = localeIndex == 0 ? sDefaultLocaleList : new LocaleListHelper(sLastDefaultLocale, sDefaultLocaleList);
        }
    }
}

