/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.RestrictTo;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.MediaRouteChooserDialog;
import android.support.v7.app.MediaRouteDevicePickerDialog;
import android.support.v7.media.MediaRouteSelector;
import android.util.Log;

public class MediaRouteChooserDialogFragment
extends DialogFragment {
    private static final String ARGUMENT_SELECTOR = "selector";
    private static final boolean USE_SUPPORT_DYNAMIC_GROUP = Log.isLoggable((String)"UseSupportDynamicGroup", (int)3);
    private Dialog mDialog;
    private MediaRouteSelector mSelector;

    public MediaRouteChooserDialogFragment() {
        this.setCancelable(true);
    }

    public MediaRouteSelector getRouteSelector() {
        this.ensureRouteSelector();
        return this.mSelector;
    }

    private void ensureRouteSelector() {
        if (this.mSelector == null) {
            Bundle args = this.getArguments();
            if (args != null) {
                this.mSelector = MediaRouteSelector.fromBundle(args.getBundle(ARGUMENT_SELECTOR));
            }
            if (this.mSelector == null) {
                this.mSelector = MediaRouteSelector.EMPTY;
            }
        }
    }

    public void setRouteSelector(MediaRouteSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        this.ensureRouteSelector();
        if (!this.mSelector.equals(selector)) {
            this.mSelector = selector;
            Bundle args = this.getArguments();
            if (args == null) {
                args = new Bundle();
            }
            args.putBundle(ARGUMENT_SELECTOR, selector.asBundle());
            this.setArguments(args);
            if (this.mDialog != null) {
                if (USE_SUPPORT_DYNAMIC_GROUP) {
                    ((MediaRouteDevicePickerDialog)this.mDialog).setRouteSelector(selector);
                } else {
                    ((MediaRouteChooserDialog)this.mDialog).setRouteSelector(selector);
                }
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaRouteDevicePickerDialog onCreateDevicePickerDialog(Context context) {
        return new MediaRouteDevicePickerDialog(context);
    }

    public MediaRouteChooserDialog onCreateChooserDialog(Context context, Bundle savedInstanceState) {
        return new MediaRouteChooserDialog(context);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (USE_SUPPORT_DYNAMIC_GROUP) {
            this.mDialog = this.onCreateDevicePickerDialog(this.getContext());
            ((MediaRouteDevicePickerDialog)this.mDialog).setRouteSelector(this.getRouteSelector());
        } else {
            this.mDialog = this.onCreateChooserDialog(this.getContext(), savedInstanceState);
            ((MediaRouteChooserDialog)this.mDialog).setRouteSelector(this.getRouteSelector());
        }
        return this.mDialog;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mDialog == null) {
            return;
        }
        if (USE_SUPPORT_DYNAMIC_GROUP) {
            ((MediaRouteDevicePickerDialog)this.mDialog).updateLayout();
        } else {
            ((MediaRouteChooserDialog)this.mDialog).updateLayout();
        }
    }
}

