/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.RestrictTo;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.MediaRouteCastDialog;
import android.support.v7.app.MediaRouteControllerDialog;
import android.support.v7.media.MediaRouteSelector;
import android.util.Log;

public class MediaRouteControllerDialogFragment
extends DialogFragment {
    private static final String ARGUMENT_SELECTOR = "selector";
    private static final boolean USE_SUPPORT_DYNAMIC_GROUP = Log.isLoggable((String)"UseSupportDynamicGroup", (int)3);
    private Dialog mDialog;
    private MediaRouteSelector mSelector;

    public MediaRouteControllerDialogFragment() {
        this.setCancelable(true);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaRouteSelector getRouteSelector() {
        this.ensureRouteSelector();
        return this.mSelector;
    }

    private void ensureRouteSelector() {
        if (this.mSelector == null) {
            Bundle args = this.getArguments();
            if (args != null) {
                this.mSelector = MediaRouteSelector.fromBundle(args.getBundle(ARGUMENT_SELECTOR));
            }
            if (this.mSelector == null) {
                this.mSelector = MediaRouteSelector.EMPTY;
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setRouteSelector(MediaRouteSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        this.ensureRouteSelector();
        if (!this.mSelector.equals(selector)) {
            this.mSelector = selector;
            Bundle args = this.getArguments();
            if (args == null) {
                args = new Bundle();
            }
            args.putBundle(ARGUMENT_SELECTOR, selector.asBundle());
            this.setArguments(args);
            if (this.mDialog != null && USE_SUPPORT_DYNAMIC_GROUP) {
                ((MediaRouteCastDialog)this.mDialog).setRouteSelector(selector);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaRouteCastDialog onCreateCastDialog(Context context) {
        return new MediaRouteCastDialog(context);
    }

    public MediaRouteControllerDialog onCreateControllerDialog(Context context, Bundle savedInstanceState) {
        return new MediaRouteControllerDialog(context);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (USE_SUPPORT_DYNAMIC_GROUP) {
            this.mDialog = this.onCreateCastDialog(this.getContext());
            ((MediaRouteCastDialog)this.mDialog).setRouteSelector(this.mSelector);
        } else {
            this.mDialog = this.onCreateControllerDialog(this.getContext(), savedInstanceState);
        }
        return this.mDialog;
    }

    public void onStop() {
        super.onStop();
        if (this.mDialog != null && !USE_SUPPORT_DYNAMIC_GROUP) {
            ((MediaRouteControllerDialog)this.mDialog).clearGroupListAnimation(false);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mDialog != null) {
            if (USE_SUPPORT_DYNAMIC_GROUP) {
                ((MediaRouteCastDialog)this.mDialog).updateLayout();
            } else {
                ((MediaRouteControllerDialog)this.mDialog).updateLayout();
            }
        }
    }
}

