/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.v7.app.AppCompatDialog;
import android.support.v7.app.MediaRouterThemeHelper;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.support.v7.mediarouter.R;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MediaRouteDevicePickerDialog
extends AppCompatDialog {
    private static final String TAG = "MediaRouteDevicePickerDialog";
    private static final int ITEM_TYPE_NONE = 0;
    private static final int ITEM_TYPE_HEADER = 1;
    private static final int ITEM_TYPE_ROUTE = 2;
    static final int MSG_UPDATE_ROUTES = 1;
    private final MediaRouter mRouter;
    private final MediaRouterCallback mCallback;
    Context mContext;
    private MediaRouteSelector mSelector;
    List<MediaRouter.RouteInfo> mRoutes;
    private ImageButton mCloseButton;
    private RecyclerAdapter mAdapter;
    private RecyclerView mRecyclerView;
    private boolean mAttachedToWindow;
    private long mUpdateRoutesDelayMs;
    private long mLastUpdateTime;
    private final Handler mHandler;

    public MediaRouteDevicePickerDialog(Context context) {
        this(context, 0);
    }

    public MediaRouteDevicePickerDialog(Context context, int theme) {
        context = MediaRouterThemeHelper.createThemedDialogContext(context, theme, false);
        super(context, MediaRouterThemeHelper.createThemedDialogStyle(context));
        this.mSelector = MediaRouteSelector.EMPTY;
        this.mHandler = new Handler(){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        MediaRouteDevicePickerDialog.this.updateRoutes((List)message.obj);
                    }
                }
            }
        };
        context = this.getContext();
        this.mRouter = MediaRouter.getInstance(context);
        this.mCallback = new MediaRouterCallback();
        this.mContext = context;
        this.mUpdateRoutesDelayMs = context.getResources().getInteger(R.integer.mr_update_routes_delay_ms);
    }

    @NonNull
    public MediaRouteSelector getRouteSelector() {
        return this.mSelector;
    }

    public void setRouteSelector(@NonNull MediaRouteSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        if (!this.mSelector.equals(selector)) {
            this.mSelector = selector;
            if (this.mAttachedToWindow) {
                this.mRouter.removeCallback(this.mCallback);
                this.mRouter.addCallback(selector, this.mCallback, 1);
            }
            this.refreshRoutes();
        }
    }

    public void onFilterRoutes(@NonNull List<MediaRouter.RouteInfo> routes) {
        int i = routes.size();
        while (i-- > 0) {
            if (this.onFilterRoute(routes.get(i))) continue;
            routes.remove(i);
        }
    }

    public boolean onFilterRoute(@NonNull MediaRouter.RouteInfo route) {
        return !route.isDefaultOrBluetooth() && route.isEnabled() && route.matchesSelector(this.mSelector);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.mr_picker_dialog);
        this.mRoutes = new ArrayList<MediaRouter.RouteInfo>();
        this.mCloseButton = (ImageButton)this.findViewById(R.id.mr_picker_close_button);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MediaRouteDevicePickerDialog.this.dismiss();
            }
        });
        this.mAdapter = new RecyclerAdapter();
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.mr_picker_list);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.updateLayout();
    }

    void updateLayout() {
        this.getWindow().setLayout(-1, -1);
    }

    @CallSuper
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(this.mSelector, this.mCallback, 1);
        this.refreshRoutes();
    }

    @CallSuper
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttachedToWindow = false;
        this.mRouter.removeCallback(this.mCallback);
        this.mHandler.removeMessages(1);
    }

    public void refreshRoutes() {
        if (this.mAttachedToWindow) {
            ArrayList<MediaRouter.RouteInfo> routes = new ArrayList<MediaRouter.RouteInfo>(this.mRouter.getRoutes());
            this.onFilterRoutes(routes);
            Collections.sort(routes, RouteComparator.sInstance);
            if (SystemClock.uptimeMillis() - this.mLastUpdateTime >= this.mUpdateRoutesDelayMs) {
                this.updateRoutes(routes);
            } else {
                this.mHandler.removeMessages(1);
                this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(1, routes), this.mLastUpdateTime + this.mUpdateRoutesDelayMs);
            }
        }
    }

    void updateRoutes(List<MediaRouter.RouteInfo> routes) {
        this.mLastUpdateTime = SystemClock.uptimeMillis();
        this.mRoutes.clear();
        this.mRoutes.addAll(routes);
        this.mAdapter.setItems();
    }

    private final class RecyclerAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private static final String TAG = "RecyclerAdapter";
        ArrayList<Item> mItems;
        private final LayoutInflater mInflater;
        private final Drawable mDefaultIcon;
        private final Drawable mTvIcon;
        private final Drawable mSpeakerIcon;
        private final Drawable mSpeakerGroupIcon;

        RecyclerAdapter() {
            this.mInflater = LayoutInflater.from((Context)MediaRouteDevicePickerDialog.this.mContext);
            this.mDefaultIcon = MediaRouterThemeHelper.getDefaultDrawableIcon(MediaRouteDevicePickerDialog.this.mContext);
            this.mTvIcon = MediaRouterThemeHelper.getTvDrawableIcon(MediaRouteDevicePickerDialog.this.mContext);
            this.mSpeakerIcon = MediaRouterThemeHelper.getSpeakerDrawableIcon(MediaRouteDevicePickerDialog.this.mContext);
            this.mSpeakerGroupIcon = MediaRouterThemeHelper.getSpeakerGropuIcon(MediaRouteDevicePickerDialog.this.mContext);
            this.setItems();
        }

        void setItems() {
            this.mItems = new ArrayList();
            ArrayList<MediaRouter.RouteInfo> routeGroups = new ArrayList<MediaRouter.RouteInfo>();
            for (int i = MediaRouteDevicePickerDialog.this.mRoutes.size() - 1; i >= 0; --i) {
                MediaRouter.RouteInfo route = MediaRouteDevicePickerDialog.this.mRoutes.get(i);
                if (!(route instanceof MediaRouter.RouteGroup)) continue;
                routeGroups.add(route);
                MediaRouteDevicePickerDialog.this.mRoutes.remove(i);
            }
            this.mItems.add(new Item(MediaRouteDevicePickerDialog.this.mContext.getString(R.string.mr_dialog_device_header)));
            for (MediaRouter.RouteInfo route : MediaRouteDevicePickerDialog.this.mRoutes) {
                this.mItems.add(new Item(route));
            }
            this.mItems.add(new Item(MediaRouteDevicePickerDialog.this.mContext.getString(R.string.mr_dialog_route_header)));
            for (MediaRouter.RouteInfo routeGroup : routeGroups) {
                this.mItems.add(new Item(routeGroup));
            }
            this.notifyDataSetChanged();
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            switch (viewType) {
                case 1: {
                    View view = this.mInflater.inflate(R.layout.mr_dialog_header_item, parent, false);
                    return new HeaderViewHolder(view);
                }
                case 2: {
                    View view = this.mInflater.inflate(R.layout.mr_picker_route_item, parent, false);
                    return new RouteViewHolder(view);
                }
            }
            Log.w((String)TAG, (String)"Cannot create ViewHolder because of wrong view type");
            return null;
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            int viewType = this.getItemViewType(position);
            Item item = this.getItem(position);
            switch (viewType) {
                case 1: {
                    ((HeaderViewHolder)holder).binHeaderView(item);
                    break;
                }
                case 2: {
                    ((RouteViewHolder)holder).bindRouteView(item);
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)"Cannot bind item to ViewHolder because of wrong view type");
                }
            }
        }

        public int getItemCount() {
            return this.mItems.size();
        }

        Drawable getIconDrawable(MediaRouter.RouteInfo route) {
            Uri iconUri = route.getIconUri();
            if (iconUri != null) {
                try {
                    InputStream is = MediaRouteDevicePickerDialog.this.mContext.getContentResolver().openInputStream(iconUri);
                    Drawable drawable2 = Drawable.createFromStream((InputStream)is, null);
                    if (drawable2 != null) {
                        return drawable2;
                    }
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)("Failed to load " + iconUri), (Throwable)e);
                }
            }
            return this.getDefaultIconDrawable(route);
        }

        private Drawable getDefaultIconDrawable(MediaRouter.RouteInfo route) {
            switch (route.getDeviceType()) {
                case 1: {
                    return this.mTvIcon;
                }
                case 2: {
                    return this.mSpeakerIcon;
                }
            }
            if (route instanceof MediaRouter.RouteGroup) {
                return this.mSpeakerGroupIcon;
            }
            return this.mDefaultIcon;
        }

        public int getItemViewType(int position) {
            return this.mItems.get(position).getType();
        }

        public Item getItem(int position) {
            return this.mItems.get(position);
        }

        private class RouteViewHolder
        extends RecyclerView.ViewHolder {
            View mItemView;
            TextView mTextView;
            ImageView mImageView;

            RouteViewHolder(View itemView) {
                super(itemView);
                this.mItemView = itemView;
                this.mTextView = (TextView)itemView.findViewById(R.id.mr_picker_route_name);
                this.mImageView = (ImageView)itemView.findViewById(R.id.mr_picker_route_icon);
            }

            public void bindRouteView(Item item) {
                final MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)item.getData();
                this.mItemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        route.select();
                    }
                });
                this.mTextView.setText((CharSequence)route.getName());
                this.mImageView.setImageDrawable(RecyclerAdapter.this.getIconDrawable(route));
            }
        }

        private class HeaderViewHolder
        extends RecyclerView.ViewHolder {
            TextView mTextView;

            HeaderViewHolder(View itemView) {
                super(itemView);
                this.mTextView = (TextView)itemView.findViewById(R.id.mr_dialog_header_name);
            }

            public void binHeaderView(Item item) {
                String headerName = item.getData().toString();
                this.mTextView.setText((CharSequence)headerName);
            }
        }

        private class Item {
            private final Object mData;
            private final int mType;

            Item(Object data) {
                this.mData = data;
                if (data instanceof String) {
                    this.mType = 1;
                } else if (data instanceof MediaRouter.RouteInfo) {
                    this.mType = 2;
                } else {
                    this.mType = 0;
                    Log.w((String)RecyclerAdapter.TAG, (String)"Wrong type of data passed to Item constructor");
                }
            }

            public Object getData() {
                return this.mData;
            }

            public int getType() {
                return this.mType;
            }
        }
    }

    static final class RouteComparator
    implements Comparator<MediaRouter.RouteInfo> {
        public static final RouteComparator sInstance = new RouteComparator();

        RouteComparator() {
        }

        @Override
        public int compare(MediaRouter.RouteInfo lhs, MediaRouter.RouteInfo rhs) {
            return lhs.getName().compareToIgnoreCase(rhs.getName());
        }
    }

    private final class MediaRouterCallback
    extends MediaRouter.Callback {
        MediaRouterCallback() {
        }

        @Override
        public void onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteDevicePickerDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteDevicePickerDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteDevicePickerDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteSelected(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteDevicePickerDialog.this.dismiss();
        }
    }
}

