/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.design.animation.AnimationUtils;
import android.support.v4.math.MathUtils;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.TintTypedArray;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CollapsingTextHelper {
    private static final boolean USE_SCALING_TEXTURE = Build.VERSION.SDK_INT < 18;
    private static final boolean DEBUG_DRAW = false;
    private static final Paint DEBUG_DRAW_PAINT = null;
    private final View view;
    private boolean drawTitle;
    private float expandedFraction;
    private final Rect expandedBounds;
    private final Rect collapsedBounds;
    private final RectF currentBounds;
    private int expandedTextGravity = 16;
    private int collapsedTextGravity = 16;
    private float expandedTextSize = 15.0f;
    private float collapsedTextSize = 15.0f;
    private ColorStateList expandedTextColor;
    private ColorStateList collapsedTextColor;
    private float expandedDrawY;
    private float collapsedDrawY;
    private float expandedDrawX;
    private float collapsedDrawX;
    private float currentDrawX;
    private float currentDrawY;
    private Typeface collapsedTypeface;
    private Typeface expandedTypeface;
    private Typeface currentTypeface;
    private CharSequence text;
    private CharSequence textToDraw;
    private boolean isRtl;
    private boolean useTexture;
    private Bitmap expandedTitleTexture;
    private Paint texturePaint;
    private float textureAscent;
    private float textureDescent;
    private float scale;
    private float currentTextSize;
    private int[] state;
    private boolean boundsChanged;
    private final TextPaint textPaint;
    private final TextPaint tmpPaint;
    private TimeInterpolator positionInterpolator;
    private TimeInterpolator textSizeInterpolator;
    private float collapsedShadowRadius;
    private float collapsedShadowDx;
    private float collapsedShadowDy;
    private int collapsedShadowColor;
    private float expandedShadowRadius;
    private float expandedShadowDx;
    private float expandedShadowDy;
    private int expandedShadowColor;

    public CollapsingTextHelper(View view) {
        this.view = view;
        this.textPaint = new TextPaint(129);
        this.tmpPaint = new TextPaint((Paint)this.textPaint);
        this.collapsedBounds = new Rect();
        this.expandedBounds = new Rect();
        this.currentBounds = new RectF();
    }

    public void setTextSizeInterpolator(TimeInterpolator interpolator) {
        this.textSizeInterpolator = interpolator;
        this.recalculate();
    }

    public void setPositionInterpolator(TimeInterpolator interpolator) {
        this.positionInterpolator = interpolator;
        this.recalculate();
    }

    public void setExpandedTextSize(float textSize) {
        if (this.expandedTextSize != textSize) {
            this.expandedTextSize = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextSize(float textSize) {
        if (this.collapsedTextSize != textSize) {
            this.collapsedTextSize = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextColor(ColorStateList textColor) {
        if (this.collapsedTextColor != textColor) {
            this.collapsedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setExpandedTextColor(ColorStateList textColor) {
        if (this.expandedTextColor != textColor) {
            this.expandedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setExpandedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingTextHelper.rectEquals(this.expandedBounds, left, top, right, bottom)) {
            this.expandedBounds.set(left, top, right, bottom);
            this.boundsChanged = true;
            this.onBoundsChanged();
        }
    }

    public void setCollapsedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingTextHelper.rectEquals(this.collapsedBounds, left, top, right, bottom)) {
            this.collapsedBounds.set(left, top, right, bottom);
            this.boundsChanged = true;
            this.onBoundsChanged();
        }
    }

    public float calculateCollapsedTextWidth() {
        if (this.text == null) {
            return 0.0f;
        }
        this.getTextPaintCollapsed(this.tmpPaint);
        return this.tmpPaint.measureText(this.text, 0, this.text.length());
    }

    public float getCollapsedTextHeight() {
        this.getTextPaintCollapsed(this.tmpPaint);
        return -this.tmpPaint.ascent();
    }

    public void getCollapsedTextActualBounds(RectF bounds) {
        boolean isRtl = this.calculateIsRtl(this.text);
        bounds.left = !isRtl ? (float)this.collapsedBounds.left : (float)this.collapsedBounds.right - this.calculateCollapsedTextWidth();
        bounds.top = this.collapsedBounds.top;
        bounds.right = !isRtl ? bounds.left + this.calculateCollapsedTextWidth() : (float)this.collapsedBounds.right;
        bounds.bottom = (float)this.collapsedBounds.top + this.getCollapsedTextHeight();
    }

    private void getTextPaintCollapsed(TextPaint textPaint) {
        textPaint.setTextSize(this.collapsedTextSize);
        textPaint.setTypeface(this.collapsedTypeface);
    }

    void onBoundsChanged() {
        this.drawTitle = this.collapsedBounds.width() > 0 && this.collapsedBounds.height() > 0 && this.expandedBounds.width() > 0 && this.expandedBounds.height() > 0;
    }

    public void setExpandedTextGravity(int gravity) {
        if (this.expandedTextGravity != gravity) {
            this.expandedTextGravity = gravity;
            this.recalculate();
        }
    }

    public int getExpandedTextGravity() {
        return this.expandedTextGravity;
    }

    public void setCollapsedTextGravity(int gravity) {
        if (this.collapsedTextGravity != gravity) {
            this.collapsedTextGravity = gravity;
            this.recalculate();
        }
    }

    public int getCollapsedTextGravity() {
        return this.collapsedTextGravity;
    }

    public void setCollapsedTextAppearance(int resId) {
        TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)this.view.getContext(), (int)resId, (int[])R.styleable.TextAppearance);
        if (a.hasValue(R.styleable.TextAppearance_android_textColor)) {
            this.collapsedTextColor = a.getColorStateList(R.styleable.TextAppearance_android_textColor);
        }
        if (a.hasValue(R.styleable.TextAppearance_android_textSize)) {
            this.collapsedTextSize = a.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, (int)this.collapsedTextSize);
        }
        this.collapsedShadowColor = a.getInt(R.styleable.TextAppearance_android_shadowColor, 0);
        this.collapsedShadowDx = a.getFloat(R.styleable.TextAppearance_android_shadowDx, 0.0f);
        this.collapsedShadowDy = a.getFloat(R.styleable.TextAppearance_android_shadowDy, 0.0f);
        this.collapsedShadowRadius = a.getFloat(R.styleable.TextAppearance_android_shadowRadius, 0.0f);
        a.recycle();
        if (Build.VERSION.SDK_INT >= 16) {
            this.collapsedTypeface = this.readFontFamilyTypeface(resId);
        }
        this.recalculate();
    }

    public void setExpandedTextAppearance(int resId) {
        TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)this.view.getContext(), (int)resId, (int[])R.styleable.TextAppearance);
        if (a.hasValue(R.styleable.TextAppearance_android_textColor)) {
            this.expandedTextColor = a.getColorStateList(R.styleable.TextAppearance_android_textColor);
        }
        if (a.hasValue(R.styleable.TextAppearance_android_textSize)) {
            this.expandedTextSize = a.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, (int)this.expandedTextSize);
        }
        this.expandedShadowColor = a.getInt(R.styleable.TextAppearance_android_shadowColor, 0);
        this.expandedShadowDx = a.getFloat(R.styleable.TextAppearance_android_shadowDx, 0.0f);
        this.expandedShadowDy = a.getFloat(R.styleable.TextAppearance_android_shadowDy, 0.0f);
        this.expandedShadowRadius = a.getFloat(R.styleable.TextAppearance_android_shadowRadius, 0.0f);
        a.recycle();
        if (Build.VERSION.SDK_INT >= 16) {
            this.expandedTypeface = this.readFontFamilyTypeface(resId);
        }
        this.recalculate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Typeface readFontFamilyTypeface(int resId) {
        TypedArray a = this.view.getContext().obtainStyledAttributes(resId, new int[]{16843692});
        try {
            String family = a.getString(0);
            if (family != null) {
                Typeface typeface = Typeface.create((String)family, (int)0);
                return typeface;
            }
        }
        finally {
            a.recycle();
        }
        return null;
    }

    public void setCollapsedTypeface(Typeface typeface) {
        if (this.collapsedTypeface != typeface) {
            this.collapsedTypeface = typeface;
            this.recalculate();
        }
    }

    public void setExpandedTypeface(Typeface typeface) {
        if (this.expandedTypeface != typeface) {
            this.expandedTypeface = typeface;
            this.recalculate();
        }
    }

    public void setTypefaces(Typeface typeface) {
        this.collapsedTypeface = this.expandedTypeface = typeface;
        this.recalculate();
    }

    public Typeface getCollapsedTypeface() {
        return this.collapsedTypeface != null ? this.collapsedTypeface : Typeface.DEFAULT;
    }

    public Typeface getExpandedTypeface() {
        return this.expandedTypeface != null ? this.expandedTypeface : Typeface.DEFAULT;
    }

    public void setExpansionFraction(float fraction) {
        if ((fraction = MathUtils.clamp((float)fraction, (float)0.0f, (float)1.0f)) != this.expandedFraction) {
            this.expandedFraction = fraction;
            this.calculateCurrentOffsets();
        }
    }

    public final boolean setState(int[] state) {
        this.state = state;
        if (this.isStateful()) {
            this.recalculate();
            return true;
        }
        return false;
    }

    public final boolean isStateful() {
        return this.collapsedTextColor != null && this.collapsedTextColor.isStateful() || this.expandedTextColor != null && this.expandedTextColor.isStateful();
    }

    public float getExpansionFraction() {
        return this.expandedFraction;
    }

    public float getCollapsedTextSize() {
        return this.collapsedTextSize;
    }

    public float getExpandedTextSize() {
        return this.expandedTextSize;
    }

    private void calculateCurrentOffsets() {
        this.calculateOffsets(this.expandedFraction);
    }

    private void calculateOffsets(float fraction) {
        this.interpolateBounds(fraction);
        this.currentDrawX = CollapsingTextHelper.lerp(this.expandedDrawX, this.collapsedDrawX, fraction, this.positionInterpolator);
        this.currentDrawY = CollapsingTextHelper.lerp(this.expandedDrawY, this.collapsedDrawY, fraction, this.positionInterpolator);
        this.setInterpolatedTextSize(CollapsingTextHelper.lerp(this.expandedTextSize, this.collapsedTextSize, fraction, this.textSizeInterpolator));
        if (this.collapsedTextColor != this.expandedTextColor) {
            this.textPaint.setColor(CollapsingTextHelper.blendColors(this.getCurrentExpandedTextColor(), this.getCurrentCollapsedTextColor(), fraction));
        } else {
            this.textPaint.setColor(this.getCurrentCollapsedTextColor());
        }
        this.textPaint.setShadowLayer(CollapsingTextHelper.lerp(this.expandedShadowRadius, this.collapsedShadowRadius, fraction, null), CollapsingTextHelper.lerp(this.expandedShadowDx, this.collapsedShadowDx, fraction, null), CollapsingTextHelper.lerp(this.expandedShadowDy, this.collapsedShadowDy, fraction, null), CollapsingTextHelper.blendColors(this.expandedShadowColor, this.collapsedShadowColor, fraction));
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    @ColorInt
    private int getCurrentExpandedTextColor() {
        if (this.state != null) {
            return this.expandedTextColor.getColorForState(this.state, 0);
        }
        return this.expandedTextColor.getDefaultColor();
    }

    @ColorInt
    @VisibleForTesting
    public int getCurrentCollapsedTextColor() {
        if (this.state != null) {
            return this.collapsedTextColor.getColorForState(this.state, 0);
        }
        return this.collapsedTextColor.getDefaultColor();
    }

    private void calculateBaseOffsets() {
        float currentTextSize = this.currentTextSize;
        this.calculateUsingTextSize(this.collapsedTextSize);
        float width = this.textToDraw != null ? this.textPaint.measureText(this.textToDraw, 0, this.textToDraw.length()) : 0.0f;
        int collapsedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.collapsedTextGravity, (int)(this.isRtl ? 1 : 0));
        switch (collapsedAbsGravity & 0x70) {
            case 80: {
                this.collapsedDrawY = this.collapsedBounds.bottom;
                break;
            }
            case 48: {
                this.collapsedDrawY = (float)this.collapsedBounds.top - this.textPaint.ascent();
                break;
            }
            default: {
                float textHeight = this.textPaint.descent() - this.textPaint.ascent();
                float textOffset = textHeight / 2.0f - this.textPaint.descent();
                this.collapsedDrawY = (float)this.collapsedBounds.centerY() + textOffset;
            }
        }
        switch (collapsedAbsGravity & 0x800007) {
            case 1: {
                this.collapsedDrawX = (float)this.collapsedBounds.centerX() - width / 2.0f;
                break;
            }
            case 5: {
                this.collapsedDrawX = (float)this.collapsedBounds.right - width;
                break;
            }
            default: {
                this.collapsedDrawX = this.collapsedBounds.left;
            }
        }
        this.calculateUsingTextSize(this.expandedTextSize);
        width = this.textToDraw != null ? this.textPaint.measureText(this.textToDraw, 0, this.textToDraw.length()) : 0.0f;
        int expandedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.expandedTextGravity, (int)(this.isRtl ? 1 : 0));
        switch (expandedAbsGravity & 0x70) {
            case 80: {
                this.expandedDrawY = this.expandedBounds.bottom;
                break;
            }
            case 48: {
                this.expandedDrawY = (float)this.expandedBounds.top - this.textPaint.ascent();
                break;
            }
            default: {
                float textHeight = this.textPaint.descent() - this.textPaint.ascent();
                float textOffset = textHeight / 2.0f - this.textPaint.descent();
                this.expandedDrawY = (float)this.expandedBounds.centerY() + textOffset;
            }
        }
        switch (expandedAbsGravity & 0x800007) {
            case 1: {
                this.expandedDrawX = (float)this.expandedBounds.centerX() - width / 2.0f;
                break;
            }
            case 5: {
                this.expandedDrawX = (float)this.expandedBounds.right - width;
                break;
            }
            default: {
                this.expandedDrawX = this.expandedBounds.left;
            }
        }
        this.clearTexture();
        this.setInterpolatedTextSize(currentTextSize);
    }

    private void interpolateBounds(float fraction) {
        this.currentBounds.left = CollapsingTextHelper.lerp(this.expandedBounds.left, this.collapsedBounds.left, fraction, this.positionInterpolator);
        this.currentBounds.top = CollapsingTextHelper.lerp(this.expandedDrawY, this.collapsedDrawY, fraction, this.positionInterpolator);
        this.currentBounds.right = CollapsingTextHelper.lerp(this.expandedBounds.right, this.collapsedBounds.right, fraction, this.positionInterpolator);
        this.currentBounds.bottom = CollapsingTextHelper.lerp(this.expandedBounds.bottom, this.collapsedBounds.bottom, fraction, this.positionInterpolator);
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        if (this.textToDraw != null && this.drawTitle) {
            float ascent;
            boolean drawTexture;
            float x = this.currentDrawX;
            float y = this.currentDrawY;
            boolean bl = drawTexture = this.useTexture && this.expandedTitleTexture != null;
            if (drawTexture) {
                ascent = this.textureAscent * this.scale;
                float descent = this.textureDescent * this.scale;
            } else {
                ascent = this.textPaint.ascent() * this.scale;
                float descent = this.textPaint.descent() * this.scale;
            }
            if (drawTexture) {
                y += ascent;
            }
            if (this.scale != 1.0f) {
                canvas.scale(this.scale, this.scale, x, y);
            }
            if (drawTexture) {
                canvas.drawBitmap(this.expandedTitleTexture, x, y, this.texturePaint);
            } else {
                canvas.drawText(this.textToDraw, 0, this.textToDraw.length(), x, y, (Paint)this.textPaint);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    private boolean calculateIsRtl(CharSequence text) {
        boolean defaultIsRtl = ViewCompat.getLayoutDirection((View)this.view) == 1;
        return (defaultIsRtl ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR).isRtl(text, 0, text.length());
    }

    private void setInterpolatedTextSize(float textSize) {
        this.calculateUsingTextSize(textSize);
        boolean bl = this.useTexture = USE_SCALING_TEXTURE && this.scale != 1.0f;
        if (this.useTexture) {
            this.ensureExpandedTexture();
        }
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private void calculateUsingTextSize(float textSize) {
        float availableWidth;
        float newTextSize;
        if (this.text == null) {
            return;
        }
        float collapsedWidth = this.collapsedBounds.width();
        float expandedWidth = this.expandedBounds.width();
        boolean updateDrawText = false;
        if (CollapsingTextHelper.isClose(textSize, this.collapsedTextSize)) {
            newTextSize = this.collapsedTextSize;
            this.scale = 1.0f;
            if (this.currentTypeface != this.collapsedTypeface) {
                this.currentTypeface = this.collapsedTypeface;
                updateDrawText = true;
            }
            availableWidth = collapsedWidth;
        } else {
            newTextSize = this.expandedTextSize;
            if (this.currentTypeface != this.expandedTypeface) {
                this.currentTypeface = this.expandedTypeface;
                updateDrawText = true;
            }
            this.scale = CollapsingTextHelper.isClose(textSize, this.expandedTextSize) ? 1.0f : textSize / this.expandedTextSize;
            float textSizeRatio = this.collapsedTextSize / this.expandedTextSize;
            float scaledDownWidth = expandedWidth * textSizeRatio;
            availableWidth = scaledDownWidth > collapsedWidth ? Math.min(collapsedWidth / textSizeRatio, expandedWidth) : expandedWidth;
        }
        if (availableWidth > 0.0f) {
            updateDrawText = this.currentTextSize != newTextSize || this.boundsChanged || updateDrawText;
            this.currentTextSize = newTextSize;
            this.boundsChanged = false;
        }
        if (this.textToDraw == null || updateDrawText) {
            this.textPaint.setTextSize(this.currentTextSize);
            this.textPaint.setTypeface(this.currentTypeface);
            this.textPaint.setLinearText(this.scale != 1.0f);
            CharSequence title = TextUtils.ellipsize((CharSequence)this.text, (TextPaint)this.textPaint, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            if (!TextUtils.equals((CharSequence)title, (CharSequence)this.textToDraw)) {
                this.textToDraw = title;
                this.isRtl = this.calculateIsRtl(this.textToDraw);
            }
        }
    }

    private void ensureExpandedTexture() {
        if (this.expandedTitleTexture != null || this.expandedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.textToDraw)) {
            return;
        }
        this.calculateOffsets(0.0f);
        this.textureAscent = this.textPaint.ascent();
        this.textureDescent = this.textPaint.descent();
        int w = Math.round(this.textPaint.measureText(this.textToDraw, 0, this.textToDraw.length()));
        int h = Math.round(this.textureDescent - this.textureAscent);
        if (w <= 0 || h <= 0) {
            return;
        }
        this.expandedTitleTexture = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.expandedTitleTexture);
        c.drawText(this.textToDraw, 0, this.textToDraw.length(), 0.0f, (float)h - this.textPaint.descent(), (Paint)this.textPaint);
        if (this.texturePaint == null) {
            this.texturePaint = new Paint(3);
        }
    }

    public void recalculate() {
        if (this.view.getHeight() > 0 && this.view.getWidth() > 0) {
            this.calculateBaseOffsets();
            this.calculateCurrentOffsets();
        }
    }

    public void setText(CharSequence text) {
        if (text == null || !text.equals(this.text)) {
            this.text = text;
            this.textToDraw = null;
            this.clearTexture();
            this.recalculate();
        }
    }

    public CharSequence getText() {
        return this.text;
    }

    private void clearTexture() {
        if (this.expandedTitleTexture != null) {
            this.expandedTitleTexture.recycle();
            this.expandedTitleTexture = null;
        }
    }

    private static boolean isClose(float value, float targetValue) {
        return Math.abs(value - targetValue) < 0.001f;
    }

    public ColorStateList getExpandedTextColor() {
        return this.expandedTextColor;
    }

    public ColorStateList getCollapsedTextColor() {
        return this.collapsedTextColor;
    }

    private static int blendColors(int color1, int color2, float ratio) {
        float inverseRatio = 1.0f - ratio;
        float a = (float)Color.alpha((int)color1) * inverseRatio + (float)Color.alpha((int)color2) * ratio;
        float r = (float)Color.red((int)color1) * inverseRatio + (float)Color.red((int)color2) * ratio;
        float g = (float)Color.green((int)color1) * inverseRatio + (float)Color.green((int)color2) * ratio;
        float b = (float)Color.blue((int)color1) * inverseRatio + (float)Color.blue((int)color2) * ratio;
        return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
    }

    private static float lerp(float startValue, float endValue, float fraction, TimeInterpolator interpolator) {
        if (interpolator != null) {
            fraction = interpolator.getInterpolation(fraction);
        }
        return AnimationUtils.lerp(startValue, endValue, fraction);
    }

    private static boolean rectEquals(Rect r, int left, int top, int right, int bottom) {
        return r.left == left && r.top == top && r.right == right && r.bottom == bottom;
    }

    static {
        if (DEBUG_DRAW_PAINT != null) {
            DEBUG_DRAW_PAINT.setAntiAlias(true);
            DEBUG_DRAW_PAINT.setColor(-65281);
        }
    }
}

