/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzac;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzigy;

    public MapView(Context context) {
        super(context);
        this.zzigy = new zzb((ViewGroup)this, context, null);
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzigy = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzigy = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzigy = new zzb((ViewGroup)this, context, googleMapOptions);
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zzigy.onCreate(bundle);
            if (this.zzigy.zzaob() == null) {
                com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public final void onResume() {
        this.zzigy.onResume();
    }

    public final void onPause() {
        this.zzigy.onPause();
    }

    public final void onStart() {
        this.zzigy.onStart();
    }

    public final void onStop() {
        this.zzigy.onStop();
    }

    public final void onDestroy() {
        this.zzigy.onDestroy();
    }

    public final void onLowMemory() {
        this.zzigy.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzigy.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbp.zzfy((String)"getMapAsync() must be called on the main thread");
        this.zzigy.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbp.zzfy((String)"onEnterAmbient() must be called on the main thread");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzigy;
        if (zzb2.zzaob() != null) {
            ((zza)zzb2.zzaob()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbp.zzfy((String)"onExitAmbient() must be called on the main thread");
        zzb zzb2 = this.zzigy;
        if (zzb2.zzaob() != null) {
            ((zza)zzb2.zzaob()).onExitAmbient();
        }
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzihc;
        private final Context zzihd;
        private zzo<zza> zzigw;
        private final GoogleMapOptions zzihe;
        private final List<OnMapReadyCallback> zzigx = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzihc = viewGroup;
            this.zzihd = context;
            this.zzihe = googleMapOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzigw = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzigw != null && zzb2.zzaob() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zzihd);
                    IMapViewDelegate iMapViewDelegate = zzbz.zzdj(zzb2.zzihd).zza(zzn.zzw((Object)zzb2.zzihd), zzb2.zzihe);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    zzb2.zzigw.zza((LifecycleDelegate)new zza(zzb2.zzihc, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : zzb2.zzigx) {
                        ((zza)zzb2.zzaob()).getMapAsync(onMapReadyCallback);
                    }
                    zzb2.zzigx.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzaob() != null) {
                ((zza)this.zzaob()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzigx.add(onMapReadyCallback);
        }
    }

    static final class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzigz;
        private final IMapViewDelegate zziha;
        private View zzihb;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zziha = (IMapViewDelegate)zzbp.zzu((Object)iMapViewDelegate);
            this.zzigz = (ViewGroup)zzbp.zzu((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zziha.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                this.zzihb = (View)zzn.zzx((IObjectWrapper)this.zziha.getView());
                this.zzigz.removeAllViews();
                this.zzigz.addView(this.zzihb);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public final void onStart() {
            try {
                this.zziha.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zziha.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zziha.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zziha.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zziha.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zziha.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zziha.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zziha.getMapAsync(new zzac(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zziha.onEnterAmbient(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zziha.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

