/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.util.ObjectsCompat;
import android.support.v7.app.AppCompatDialog;
import android.support.v7.app.MediaRouteChooserDialog;
import android.support.v7.app.MediaRouteVolumeSlider;
import android.support.v7.app.MediaRouterThemeHelper;
import android.support.v7.graphics.Palette;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.support.v7.mediarouter.R;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MediaRouteCastDialog
extends AppCompatDialog {
    static final String TAG = "MediaRouteCastDialog";
    static final int CONNECTION_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final long UPDATE_ROUTES_DELAY_MS = 300L;
    static final int MSG_UPDATE_ROUTES = 1;
    final MediaRouter mRouter;
    private final MediaRouterCallback mCallback;
    private MediaRouteSelector mSelector;
    final MediaRouter.RouteInfo mRoute;
    final List<MediaRouter.RouteInfo> mRoutes;
    Context mContext;
    private boolean mCreated;
    private boolean mAttachedToWindow;
    private long mLastUpdateTime;
    private final Handler mHandler;
    private RecyclerView mRecyclerView;
    private RecyclerAdapter mAdapter;
    VolumeChangeListener mVolumeChangeListener;
    int mVolumeSliderColor;
    private ImageButton mCloseButton;
    private Button mStopCastingButton;
    private RelativeLayout mMetadataLayout;
    private ImageView mArtView;
    private TextView mTitleView;
    private TextView mSubtitleView;
    private String mTitlePlaceholder;
    MediaControllerCompat mMediaController;
    MediaControllerCallback mControllerCallback;
    MediaDescriptionCompat mDescription;
    FetchArtTask mFetchArtTask;
    Bitmap mArtIconBitmap;
    Uri mArtIconUri;
    boolean mArtIconIsLoaded;
    Bitmap mArtIconLoadedBitmap;
    int mArtIconBackgroundColor;

    public MediaRouteCastDialog(Context context) {
        this(context, 0);
    }

    public MediaRouteCastDialog(Context context, int theme) {
        context = MediaRouterThemeHelper.createThemedDialogContext(context, theme, false);
        super(context, MediaRouterThemeHelper.createThemedDialogStyle(context));
        this.mSelector = MediaRouteSelector.EMPTY;
        this.mRoutes = new ArrayList<MediaRouter.RouteInfo>();
        this.mHandler = new Handler(){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        MediaRouteCastDialog.this.updateRoutes((List)message.obj);
                    }
                }
            }
        };
        this.mContext = this.getContext();
        this.mRouter = MediaRouter.getInstance(this.mContext);
        this.mCallback = new MediaRouterCallback();
        this.mRoute = this.mRouter.getSelectedRoute();
        this.mControllerCallback = new MediaControllerCallback();
        this.setMediaSession(this.mRouter.getMediaSessionToken());
    }

    private void setMediaSession(MediaSessionCompat.Token sessionToken) {
        if (this.mMediaController != null) {
            this.mMediaController.unregisterCallback((MediaControllerCompat.Callback)this.mControllerCallback);
            this.mMediaController = null;
        }
        if (sessionToken == null) {
            return;
        }
        if (!this.mAttachedToWindow) {
            return;
        }
        try {
            this.mMediaController = new MediaControllerCompat(this.mContext, sessionToken);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error creating media controller in setMediaSession.", (Throwable)e);
        }
        if (this.mMediaController != null) {
            this.mMediaController.registerCallback((MediaControllerCompat.Callback)this.mControllerCallback);
        }
        MediaMetadataCompat metadata = this.mMediaController == null ? null : this.mMediaController.getMetadata();
        this.mDescription = metadata == null ? null : metadata.getDescription();
        this.updateArtIconIfNeeded();
        this.update();
    }

    public MediaSessionCompat.Token getMediaSession() {
        return this.mMediaController == null ? null : this.mMediaController.getSessionToken();
    }

    @NonNull
    public MediaRouteSelector getRouteSelector() {
        return this.mSelector;
    }

    public void setRouteSelector(@NonNull MediaRouteSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        if (!this.mSelector.equals(selector)) {
            this.mSelector = selector;
            if (this.mAttachedToWindow) {
                this.mRouter.removeCallback(this.mCallback);
                this.mRouter.addCallback(selector, this.mCallback, 1);
            }
            this.refreshRoutes();
        }
    }

    public void onFilterRoutes(@NonNull List<MediaRouter.RouteInfo> routes) {
        for (int i = routes.size() - 1; i >= 0; --i) {
            if (this.onFilterRoute(routes.get(i))) continue;
            routes.remove(i);
        }
    }

    public boolean onFilterRoute(@NonNull MediaRouter.RouteInfo route) {
        return !route.isDefaultOrBluetooth() && route.isEnabled() && route.matchesSelector(this.mSelector);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.mr_cast_dialog);
        this.mCloseButton = (ImageButton)this.findViewById(R.id.mr_cast_close_button);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MediaRouteCastDialog.this.dismiss();
            }
        });
        this.mStopCastingButton = (Button)this.findViewById(R.id.mr_cast_stop_button);
        this.mStopCastingButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MediaRouteCastDialog.this.mRoute.isSelected()) {
                    MediaRouteCastDialog.this.mRouter.unselect(2);
                }
                MediaRouteCastDialog.this.dismiss();
            }
        });
        this.mAdapter = new RecyclerAdapter();
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.mr_cast_list);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.mVolumeChangeListener = new VolumeChangeListener();
        this.mVolumeSliderColor = MediaRouterThemeHelper.getControllerColor(this.mContext, 0);
        this.mMetadataLayout = (RelativeLayout)this.findViewById(R.id.mr_cast_meta);
        this.mArtView = (ImageView)this.findViewById(R.id.mr_cast_meta_art);
        this.mTitleView = (TextView)this.findViewById(R.id.mr_cast_meta_title);
        this.mSubtitleView = (TextView)this.findViewById(R.id.mr_cast_meta_subtitle);
        Resources res = this.mContext.getResources();
        this.mTitlePlaceholder = res.getString(R.string.mr_cast_dialog_title_view_placeholder);
        this.mCreated = true;
        this.updateLayout();
    }

    void updateLayout() {
        this.getWindow().setLayout(-1, -1);
        this.mArtIconBitmap = null;
        this.mArtIconUri = null;
        this.updateArtIconIfNeeded();
        this.update();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(this.mSelector, this.mCallback, 1);
        this.refreshRoutes();
        this.setMediaSession(this.mRouter.getMediaSessionToken());
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttachedToWindow = false;
        this.mRouter.removeCallback(this.mCallback);
        this.mHandler.removeMessages(1);
        this.setMediaSession(null);
    }

    void update() {
        if (!this.mRoute.isSelected() || this.mRoute.isDefaultOrBluetooth()) {
            this.dismiss();
            return;
        }
        if (!this.mCreated) {
            return;
        }
        if (this.mArtIconIsLoaded) {
            if (MediaRouteCastDialog.isBitmapRecycled(this.mArtIconLoadedBitmap)) {
                this.mArtView.setVisibility(8);
                Log.w((String)TAG, (String)("Can't set artwork image with recycled bitmap: " + this.mArtIconLoadedBitmap));
            } else {
                this.mArtView.setVisibility(0);
                this.mArtView.setImageBitmap(this.mArtIconLoadedBitmap);
                this.mArtView.setBackgroundColor(this.mArtIconBackgroundColor);
                this.mMetadataLayout.setBackgroundDrawable((Drawable)new BitmapDrawable(this.mArtIconLoadedBitmap));
            }
            this.clearLoadedBitmap();
        } else {
            this.mArtView.setVisibility(8);
        }
        this.updateMetadataLayout();
    }

    static boolean isBitmapRecycled(Bitmap bitmap) {
        return bitmap != null && bitmap.isRecycled();
    }

    int getDesiredArtHeight(int originalWidth, int originalHeight) {
        return this.mArtView.getHeight();
    }

    void updateArtIconIfNeeded() {
        if (!this.isIconChanged()) {
            return;
        }
        if (this.mFetchArtTask != null) {
            this.mFetchArtTask.cancel(true);
        }
        this.mFetchArtTask = new FetchArtTask();
        this.mFetchArtTask.execute(new Void[0]);
    }

    void clearLoadedBitmap() {
        this.mArtIconIsLoaded = false;
        this.mArtIconLoadedBitmap = null;
        this.mArtIconBackgroundColor = 0;
    }

    private boolean isIconChanged() {
        Uri oldUri;
        Bitmap newBitmap = this.mDescription == null ? null : this.mDescription.getIconBitmap();
        Uri newUri = this.mDescription == null ? null : this.mDescription.getIconUri();
        Bitmap oldBitmap = this.mFetchArtTask == null ? this.mArtIconBitmap : this.mFetchArtTask.getIconBitmap();
        Uri uri = oldUri = this.mFetchArtTask == null ? this.mArtIconUri : this.mFetchArtTask.getIconUri();
        if (oldBitmap != newBitmap) {
            return true;
        }
        return oldBitmap == null && ObjectsCompat.equals((Object)oldUri, (Object)newUri);
    }

    private void updateMetadataLayout() {
        boolean hasSubtitle;
        CharSequence title = this.mDescription == null ? null : this.mDescription.getTitle();
        boolean hasTitle = !TextUtils.isEmpty((CharSequence)title);
        CharSequence subtitle = this.mDescription == null ? null : this.mDescription.getSubtitle();
        boolean bl = hasSubtitle = !TextUtils.isEmpty((CharSequence)subtitle);
        if (hasTitle) {
            this.mTitleView.setText(title);
        } else {
            this.mTitleView.setText((CharSequence)this.mTitlePlaceholder);
        }
        if (hasSubtitle) {
            this.mSubtitleView.setText(subtitle);
            this.mSubtitleView.setVisibility(0);
        } else {
            this.mSubtitleView.setVisibility(8);
        }
    }

    public void refreshRoutes() {
        if (this.mAttachedToWindow) {
            ArrayList<MediaRouter.RouteInfo> routes = new ArrayList<MediaRouter.RouteInfo>(this.mRouter.getRoutes());
            this.onFilterRoutes(routes);
            Collections.sort(routes, MediaRouteChooserDialog.RouteComparator.sInstance);
            if (SystemClock.uptimeMillis() - this.mLastUpdateTime >= 300L) {
                this.updateRoutes(routes);
            } else {
                this.mHandler.removeMessages(1);
                this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(1, routes), this.mLastUpdateTime + 300L);
            }
        }
    }

    void updateRoutes(List<MediaRouter.RouteInfo> routes) {
        this.mLastUpdateTime = SystemClock.uptimeMillis();
        this.mRoutes.clear();
        this.mRoutes.addAll(routes);
        this.mAdapter.setItems();
    }

    private class FetchArtTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final Bitmap mIconBitmap;
        private final Uri mIconUri;
        private int mBackgroundColor;

        FetchArtTask() {
            Bitmap bitmap;
            Bitmap bitmap2 = bitmap = MediaRouteCastDialog.this.mDescription == null ? null : MediaRouteCastDialog.this.mDescription.getIconBitmap();
            if (MediaRouteCastDialog.isBitmapRecycled(bitmap)) {
                Log.w((String)MediaRouteCastDialog.TAG, (String)"Can't fetch the given art bitmap because it's already recycled.");
                bitmap = null;
            }
            this.mIconBitmap = bitmap;
            this.mIconUri = MediaRouteCastDialog.this.mDescription == null ? null : MediaRouteCastDialog.this.mDescription.getIconUri();
        }

        public Bitmap getIconBitmap() {
            return this.mIconBitmap;
        }

        public Uri getIconUri() {
            return this.mIconUri;
        }

        protected void onPreExecute() {
            MediaRouteCastDialog.this.clearLoadedBitmap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Bitmap doInBackground(Void ... arg) {
            Bitmap art = null;
            if (this.mIconBitmap != null) {
                art = this.mIconBitmap;
            } else if (this.mIconUri != null) {
                InputStream stream = null;
                try {
                    BitmapFactory.Options options;
                    block33: {
                        stream = this.openInputStreamByScheme(this.mIconUri);
                        if (stream == null) {
                            Log.w((String)MediaRouteCastDialog.TAG, (String)("Unable to open: " + this.mIconUri));
                            Bitmap bitmap = null;
                            return bitmap;
                        }
                        options = new BitmapFactory.Options();
                        options.inJustDecodeBounds = true;
                        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
                        if (options.outWidth == 0 || options.outHeight == 0) {
                            Bitmap bitmap = null;
                            return bitmap;
                        }
                        try {
                            stream.reset();
                        }
                        catch (IOException e) {
                            stream.close();
                            stream = this.openInputStreamByScheme(this.mIconUri);
                            if (stream != null) break block33;
                            Log.w((String)MediaRouteCastDialog.TAG, (String)("Unable to open: " + this.mIconUri));
                            Bitmap bitmap = null;
                            if (stream == null) return bitmap;
                            try {
                                stream.close();
                                return bitmap;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return bitmap;
                        }
                    }
                    options.inJustDecodeBounds = false;
                    int reqHeight = MediaRouteCastDialog.this.getDesiredArtHeight(options.outWidth, options.outHeight);
                    int ratio = options.outHeight / reqHeight;
                    options.inSampleSize = Math.max(1, Integer.highestOneBit(ratio));
                    if (this.isCancelled()) {
                        Bitmap bitmap = null;
                        return bitmap;
                    }
                    art = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
                }
                catch (IOException e) {
                    Log.w((String)MediaRouteCastDialog.TAG, (String)("Unable to open: " + this.mIconUri), (Throwable)e);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (MediaRouteCastDialog.isBitmapRecycled(art)) {
                Log.w((String)MediaRouteCastDialog.TAG, (String)("Can't use recycled bitmap: " + art));
                return null;
            }
            if (art == null) return art;
            if (art.getWidth() >= art.getHeight()) return art;
            Palette palette = new Palette.Builder(art).maximumColorCount(1).generate();
            this.mBackgroundColor = palette.getSwatches().isEmpty() ? 0 : ((Palette.Swatch)palette.getSwatches().get(0)).getRgb();
            return art;
        }

        protected void onPostExecute(Bitmap art) {
            MediaRouteCastDialog.this.mFetchArtTask = null;
            if (!ObjectsCompat.equals((Object)MediaRouteCastDialog.this.mArtIconBitmap, (Object)this.mIconBitmap) || !ObjectsCompat.equals((Object)MediaRouteCastDialog.this.mArtIconUri, (Object)this.mIconUri)) {
                MediaRouteCastDialog.this.mArtIconBitmap = this.mIconBitmap;
                MediaRouteCastDialog.this.mArtIconLoadedBitmap = art;
                MediaRouteCastDialog.this.mArtIconUri = this.mIconUri;
                MediaRouteCastDialog.this.mArtIconBackgroundColor = this.mBackgroundColor;
                MediaRouteCastDialog.this.mArtIconIsLoaded = true;
                MediaRouteCastDialog.this.update();
            }
        }

        private InputStream openInputStreamByScheme(Uri uri) throws IOException {
            String scheme = uri.getScheme().toLowerCase();
            InputStream stream = null;
            if ("android.resource".equals(scheme) || "content".equals(scheme) || "file".equals(scheme)) {
                stream = MediaRouteCastDialog.this.mContext.getContentResolver().openInputStream(uri);
            } else {
                URL url = new URL(uri.toString());
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(CONNECTION_TIMEOUT_MILLIS);
                conn.setReadTimeout(CONNECTION_TIMEOUT_MILLIS);
                stream = conn.getInputStream();
            }
            return stream == null ? null : new BufferedInputStream(stream);
        }
    }

    private final class MediaControllerCallback
    extends MediaControllerCompat.Callback {
        MediaControllerCallback() {
        }

        public void onSessionDestroyed() {
            if (MediaRouteCastDialog.this.mMediaController != null) {
                MediaRouteCastDialog.this.mMediaController.unregisterCallback((MediaControllerCompat.Callback)MediaRouteCastDialog.this.mControllerCallback);
                MediaRouteCastDialog.this.mMediaController = null;
            }
        }

        public void onMetadataChanged(MediaMetadataCompat metadata) {
            MediaRouteCastDialog.this.mDescription = metadata == null ? null : metadata.getDescription();
            MediaRouteCastDialog.this.updateArtIconIfNeeded();
            MediaRouteCastDialog.this.update();
        }
    }

    private final class MediaRouterCallback
    extends MediaRouter.Callback {
        MediaRouterCallback() {
        }

        @Override
        public void onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteCastDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteCastDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteSelected(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteCastDialog.this.update();
        }

        @Override
        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteCastDialog.this.update();
        }

        @Override
        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteCastDialog.this.refreshRoutes();
            MediaRouteCastDialog.this.update();
        }
    }

    private final class RecyclerAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private static final String TAG = "RecyclerAdapter";
        private static final int ITEM_TYPE_GROUP_VOLUME = 1;
        private static final int ITEM_TYPE_HEADER = 2;
        private static final int ITEM_TYPE_ROUTE = 3;
        private static final int ITEM_TYPE_GROUP = 4;
        private final ArrayList<Item> mItems = new ArrayList();
        private final ArrayList<MediaRouter.RouteInfo> mAvailableRoutes = new ArrayList();
        private final ArrayList<MediaRouter.RouteInfo> mAvailableGroups = new ArrayList();
        private final LayoutInflater mInflater;
        private final Drawable mDefaultIcon;
        private final Drawable mTvIcon;
        private final Drawable mSpeakerIcon;
        private final Drawable mSpeakerGroupIcon;

        RecyclerAdapter() {
            this.mInflater = LayoutInflater.from((Context)MediaRouteCastDialog.this.mContext);
            this.mDefaultIcon = MediaRouterThemeHelper.getDefaultDrawableIcon(MediaRouteCastDialog.this.mContext);
            this.mTvIcon = MediaRouterThemeHelper.getTvDrawableIcon(MediaRouteCastDialog.this.mContext);
            this.mSpeakerIcon = MediaRouterThemeHelper.getSpeakerDrawableIcon(MediaRouteCastDialog.this.mContext);
            this.mSpeakerGroupIcon = MediaRouterThemeHelper.getSpeakerGropuIcon(MediaRouteCastDialog.this.mContext);
            this.setItems();
        }

        boolean isSelectedRoute(MediaRouter.RouteInfo route) {
            if (route.isSelected()) {
                return true;
            }
            if (MediaRouteCastDialog.this.mRoute instanceof MediaRouter.RouteGroup) {
                List<MediaRouter.RouteInfo> memberRoutes = ((MediaRouter.RouteGroup)MediaRouteCastDialog.this.mRoute).getRoutes();
                for (MediaRouter.RouteInfo memberRoute : memberRoutes) {
                    if (!memberRoute.getId().equals(route.getId())) continue;
                    return true;
                }
            }
            return false;
        }

        void setItems() {
            this.mItems.clear();
            if (MediaRouteCastDialog.this.mRoute instanceof MediaRouter.RouteGroup) {
                this.mItems.add(new Item(MediaRouteCastDialog.this.mRoute, 1));
                List<MediaRouter.RouteInfo> routes = ((MediaRouter.RouteGroup)MediaRouteCastDialog.this.mRoute).getRoutes();
                for (MediaRouter.RouteInfo route : routes) {
                    this.mItems.add(new Item(route, 3));
                }
            } else {
                this.mItems.add(new Item(MediaRouteCastDialog.this.mRoute, 3));
            }
            this.mAvailableRoutes.clear();
            this.mAvailableGroups.clear();
            for (MediaRouter.RouteInfo route : MediaRouteCastDialog.this.mRoutes) {
                if (this.isSelectedRoute(route)) continue;
                if (route instanceof MediaRouter.RouteGroup) {
                    this.mAvailableGroups.add(route);
                    continue;
                }
                this.mAvailableRoutes.add(route);
            }
            if (this.mAvailableRoutes.size() > 0) {
                this.mItems.add(new Item(MediaRouteCastDialog.this.mContext.getString(R.string.mr_dialog_device_header), 2));
                for (MediaRouter.RouteInfo route : this.mAvailableRoutes) {
                    this.mItems.add(new Item(route, 3));
                }
            }
            if (this.mAvailableGroups.size() > 0) {
                this.mItems.add(new Item(MediaRouteCastDialog.this.mContext.getString(R.string.mr_dialog_route_header), 2));
                for (MediaRouter.RouteInfo route : this.mAvailableGroups) {
                    this.mItems.add(new Item(route, 4));
                }
            }
            this.notifyDataSetChanged();
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            switch (viewType) {
                case 1: {
                    View view = this.mInflater.inflate(R.layout.mr_cast_group_volume_item, parent, false);
                    return new GroupVolumeViewHolder(view);
                }
                case 2: {
                    View view = this.mInflater.inflate(R.layout.mr_dialog_header_item, parent, false);
                    return new HeaderViewHolder(view);
                }
                case 3: {
                    View view = this.mInflater.inflate(R.layout.mr_cast_route_item, parent, false);
                    return new RouteViewHolder(view);
                }
                case 4: {
                    View view = this.mInflater.inflate(R.layout.mr_cast_group_item, parent, false);
                    return new GroupViewHolder(view);
                }
            }
            Log.w((String)TAG, (String)"Cannot create ViewHolder because of wrong view type");
            return null;
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            int viewType = this.getItemViewType(position);
            Item item = this.getItem(position);
            switch (viewType) {
                case 1: {
                    ((GroupVolumeViewHolder)holder).bindGroupVolumeView(item);
                    break;
                }
                case 2: {
                    ((HeaderViewHolder)holder).bindHeaderViewHolder(item);
                    break;
                }
                case 3: {
                    ((RouteViewHolder)holder).bindRouteViewHolder(item);
                    break;
                }
                case 4: {
                    ((GroupViewHolder)holder).bindGroupViewHolder(item);
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)"Cannot bind item to ViewHolder because of wrong view type");
                }
            }
        }

        public int getItemCount() {
            return this.mItems.size();
        }

        Drawable getIconDrawable(MediaRouter.RouteInfo route) {
            Uri iconUri = route.getIconUri();
            if (iconUri != null) {
                try {
                    InputStream is = MediaRouteCastDialog.this.mContext.getContentResolver().openInputStream(iconUri);
                    Drawable drawable = Drawable.createFromStream((InputStream)is, null);
                    if (drawable != null) {
                        return drawable;
                    }
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)("Failed to load " + iconUri), (Throwable)e);
                }
            }
            return this.getDefaultIconDrawable(route);
        }

        private Drawable getDefaultIconDrawable(MediaRouter.RouteInfo route) {
            switch (route.getDeviceType()) {
                case 1: {
                    return this.mTvIcon;
                }
                case 2: {
                    return this.mSpeakerIcon;
                }
            }
            if (route instanceof MediaRouter.RouteGroup) {
                return this.mSpeakerGroupIcon;
            }
            return this.mDefaultIcon;
        }

        public int getItemViewType(int position) {
            return this.mItems.get(position).getType();
        }

        public Item getItem(int position) {
            return this.mItems.get(position);
        }

        private class GroupViewHolder
        extends RecyclerView.ViewHolder {
            ImageView mImageView;
            TextView mTextView;

            GroupViewHolder(View itemView) {
                super(itemView);
                this.mImageView = (ImageView)itemView.findViewById(R.id.mr_cast_group_icon);
                this.mTextView = (TextView)itemView.findViewById(R.id.mr_cast_group_name);
            }

            public void bindGroupViewHolder(Item item) {
                MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)item.getData();
                this.mImageView.setImageDrawable(RecyclerAdapter.this.getIconDrawable(route));
                this.mTextView.setText((CharSequence)route.getName());
            }
        }

        private class RouteViewHolder
        extends RecyclerView.ViewHolder {
            ImageView mImageView;
            TextView mTextView;
            CheckBox mCheckBox;
            MediaRouteVolumeSlider mVolumeSlider;

            RouteViewHolder(View itemView) {
                super(itemView);
                this.mImageView = (ImageView)itemView.findViewById(R.id.mr_cast_route_icon);
                this.mTextView = (TextView)itemView.findViewById(R.id.mr_cast_route_name);
                this.mCheckBox = (CheckBox)itemView.findViewById(R.id.mr_cast_checkbox);
                this.mVolumeSlider = (MediaRouteVolumeSlider)itemView.findViewById(R.id.mr_cast_volume_slider);
            }

            public void bindRouteViewHolder(Item item) {
                MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)item.getData();
                this.mImageView.setImageDrawable(RecyclerAdapter.this.getIconDrawable(route));
                this.mTextView.setText((CharSequence)route.getName());
                this.mCheckBox.setChecked(RecyclerAdapter.this.isSelectedRoute(route));
                this.mVolumeSlider.setColor(MediaRouteCastDialog.this.mVolumeSliderColor);
                this.mVolumeSlider.setTag(route);
                this.mVolumeSlider.setProgress(route.getVolume());
                this.mVolumeSlider.setOnSeekBarChangeListener(MediaRouteCastDialog.this.mVolumeChangeListener);
            }
        }

        private class HeaderViewHolder
        extends RecyclerView.ViewHolder {
            TextView mTextView;

            HeaderViewHolder(View itemView) {
                super(itemView);
                this.mTextView = (TextView)itemView.findViewById(R.id.mr_dialog_header_name);
            }

            public void bindHeaderViewHolder(Item item) {
                String headerName = item.getData().toString();
                this.mTextView.setText((CharSequence)headerName.toUpperCase());
            }
        }

        private class GroupVolumeViewHolder
        extends RecyclerView.ViewHolder {
            TextView mTextView;
            MediaRouteVolumeSlider mGroupVolumeSlider;

            GroupVolumeViewHolder(View itemView) {
                super(itemView);
                this.mTextView = (TextView)itemView.findViewById(R.id.mr_group_volume_route_name);
                this.mGroupVolumeSlider = (MediaRouteVolumeSlider)itemView.findViewById(R.id.mr_group_volume_slider);
            }

            public void bindGroupVolumeView(Item item) {
                MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)item.getData();
                this.mTextView.setText((CharSequence)route.getName().toUpperCase());
                this.mGroupVolumeSlider.setColor(MediaRouteCastDialog.this.mVolumeSliderColor);
                this.mGroupVolumeSlider.setTag(route);
                this.mGroupVolumeSlider.setProgress(MediaRouteCastDialog.this.mRoute.getVolume());
                this.mGroupVolumeSlider.setOnSeekBarChangeListener(MediaRouteCastDialog.this.mVolumeChangeListener);
            }
        }

        private class Item {
            private final Object mData;
            private final int mType;

            Item(Object data, int type) {
                this.mData = data;
                this.mType = type;
            }

            public Object getData() {
                return this.mData;
            }

            public int getType() {
                return this.mType;
            }
        }
    }

    private class VolumeChangeListener
    implements SeekBar.OnSeekBarChangeListener {
        VolumeChangeListener() {
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        }
    }
}

